package cn.sinozg.applet.quartz.use.module;

import io.swagger.v3.oas.annotations.media.Schema;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 非 cron 类的周期任务
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-11 12:40
 */
public class SchedulerCycleParams extends SchedulerBaseParams {

    /** 循环执行类型 01 按周 02 按月 */
    @Schema(description = "循环执行类型 01 按周 02 按月")
    @NotNull(message = "循环执行类型不能为空！")
    private String runCycle;

    @Schema(description = "运行的时间 0表示所有 周：1星期天-7 ，日：1-31")
    @NotNull(message = "运行的时间不能为空！")
    private List<Integer> runDays;

    /**
     * 获取 循环执行类型 01 按周 02 按月
     *
     * @return runCycle 循环执行类型 01 按周 02 按月
     */
    public String getRunCycle() {
        return this.runCycle;
    }

    /**
     * 设置 循环执行类型 01 按周 02 按月
     *
     * @param runCycle 循环执行类型 01 按周 02 按月
     */
    public void setRunCycle(String runCycle) {
        this.runCycle = runCycle;
    }

    /**
     * 获取 @Schema(description = "运行的时间 0表示所有 周：1星期天-7 ，日：1-31")    @NotNull(message = "运行的时间不能为空！")
     *
     * @return runDays @Schema(description = "运行的时间 0表示所有 周：1星期天-7 ，日：1-31")    @NotNull(message = "运行的时间不能为空！")
     */
    public List<Integer> getRunDays() {
        return this.runDays;
    }

    /**
     * 设置 @Schema(description = "运行的时间 0表示所有 周：1星期天-7 ，日：1-31")    @NotNull(message = "运行的时间不能为空！")
     *
     * @param runDays @Schema(description = "运行的时间 0表示所有 周：1星期天-7 ，日：1-31")    @NotNull(message = "运行的时间不能为空！")
     */
    public void setRunDays(List<Integer> runDays) {
        this.runDays = runDays;
    }
}
