/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.quartz.use.ext;

import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.quartz.use.ext.DailyTimeIntervalMonthTrigger;
import cn.sinozg.applet.quartz.use.ext.DailyTimeIntervalTriggerMonthImpl;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.quartz.DateBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.TimeOfDay;
import org.quartz.spi.MutableTrigger;

public class DailyTimeIntervalMonthScheduleBuilder
extends ScheduleBuilder<DailyTimeIntervalMonthTrigger> {
    private int interval = 1;
    private DateBuilder.IntervalUnit intervalUnit = DateBuilder.IntervalUnit.MINUTE;
    private Set<Integer> daysOfMonth;
    private TimeOfDay startTimeOfDay;
    private TimeOfDay endTimeOfDay;
    private int repeatCount = -1;
    private int misfireInstruction = 0;
    public static final Set<Integer> ALL_DAYS_OF_THE_MONTH;
    private static final TimeOfDay STARTING_DAILY;
    private static final TimeOfDay ENDING_DAILY;

    protected DailyTimeIntervalMonthScheduleBuilder() {
    }

    public static DailyTimeIntervalMonthScheduleBuilder dailyTimeIntervalSchedule() {
        return new DailyTimeIntervalMonthScheduleBuilder();
    }

    public MutableTrigger build() {
        DailyTimeIntervalTriggerMonthImpl st = new DailyTimeIntervalTriggerMonthImpl();
        st.setRepeatInterval(this.interval);
        st.setRepeatIntervalUnit(this.intervalUnit);
        st.setMisfireInstruction(this.misfireInstruction);
        st.setRepeatCount(this.repeatCount);
        if (this.daysOfMonth != null) {
            st.setDaysOfMonth(this.daysOfMonth);
        } else {
            st.setDaysOfMonth(ALL_DAYS_OF_THE_MONTH);
        }
        if (this.startTimeOfDay != null) {
            st.setStartTimeOfDay(this.startTimeOfDay);
        } else {
            st.setStartTimeOfDay(STARTING_DAILY);
        }
        if (this.endTimeOfDay != null) {
            st.setEndTimeOfDay(this.endTimeOfDay);
        } else {
            st.setEndTimeOfDay(ENDING_DAILY);
        }
        return st;
    }

    public DailyTimeIntervalMonthScheduleBuilder withInterval(int timeInterval, DateBuilder.IntervalUnit unit) {
        boolean params;
        boolean bl = params = unit == null || !unit.equals((Object)DateBuilder.IntervalUnit.SECOND) && !unit.equals((Object)DateBuilder.IntervalUnit.MINUTE) && !unit.equals((Object)DateBuilder.IntervalUnit.HOUR);
        if (params) {
            throw new IllegalArgumentException("Invalid repeat IntervalUnit (must be SECOND, MINUTE or HOUR).");
        }
        this.validateInterval(timeInterval);
        this.interval = timeInterval;
        this.intervalUnit = unit;
        return this;
    }

    public DailyTimeIntervalMonthScheduleBuilder withIntervalInSeconds(int intervalInSeconds) {
        this.withInterval(intervalInSeconds, DateBuilder.IntervalUnit.SECOND);
        return this;
    }

    public DailyTimeIntervalMonthScheduleBuilder withIntervalInMinutes(int intervalInMinutes) {
        this.withInterval(intervalInMinutes, DateBuilder.IntervalUnit.MINUTE);
        return this;
    }

    public DailyTimeIntervalMonthScheduleBuilder withIntervalInHours(int intervalInHours) {
        this.withInterval(intervalInHours, DateBuilder.IntervalUnit.HOUR);
        return this;
    }

    public DailyTimeIntervalMonthScheduleBuilder onDaysOfTheMonth(Set<Integer> onDaysOfMonth) {
        if (CollectionUtils.isEmpty(onDaysOfMonth)) {
            throw new IllegalArgumentException("Days of week must be an non-empty set.");
        }
        for (Integer day : onDaysOfMonth) {
            if (ALL_DAYS_OF_THE_MONTH.contains(day)) continue;
            throw new IllegalArgumentException("Invalid value for day of week: " + day);
        }
        this.daysOfMonth = onDaysOfMonth;
        return this;
    }

    public DailyTimeIntervalMonthScheduleBuilder onDaysOfTheMonth(Integer ... onDaysOfMonth) {
        HashSet<Integer> daysAsSet = new HashSet<Integer>(64);
        Collections.addAll(daysAsSet, onDaysOfMonth);
        return this.onDaysOfTheMonth(daysAsSet);
    }

    public DailyTimeIntervalMonthScheduleBuilder onEveryDay() {
        this.daysOfMonth = ALL_DAYS_OF_THE_MONTH;
        return this;
    }

    public DailyTimeIntervalMonthScheduleBuilder startingDailyAt(TimeOfDay timeOfDay) {
        if (timeOfDay == null) {
            throw new IllegalArgumentException("Start time of day cannot be null!");
        }
        this.startTimeOfDay = timeOfDay;
        return this;
    }

    public DailyTimeIntervalMonthScheduleBuilder endingDailyAt(TimeOfDay timeOfDay) {
        this.endTimeOfDay = timeOfDay;
        return this;
    }

    public DailyTimeIntervalMonthScheduleBuilder endingDailyAfterCount(int count) {
        long intervalInMillis;
        if (count <= 0) {
            throw new IllegalArgumentException("Ending daily after count must be a positive number!");
        }
        if (this.startTimeOfDay == null) {
            throw new IllegalArgumentException("You must set the startDailyAt() before calling this endingDailyAfterCount()!");
        }
        Date today = new Date();
        long startTimeOfDayDateMillis = this.startTimeOfDay.getTimeOfDayForDate(today).getTime();
        long maxEndTimeOfDayDateMillis = ENDING_DAILY.getTimeOfDayForDate(today).getTime();
        long remainingMillisInDay = maxEndTimeOfDayDateMillis - startTimeOfDayDateMillis;
        if (this.intervalUnit == DateBuilder.IntervalUnit.SECOND) {
            intervalInMillis = (long)this.interval * 1000L;
        } else if (this.intervalUnit == DateBuilder.IntervalUnit.MINUTE) {
            intervalInMillis = (long)this.interval * 1000L * 60L;
        } else if (this.intervalUnit == DateBuilder.IntervalUnit.HOUR) {
            intervalInMillis = (long)this.interval * 1000L * 60L * 24L;
        } else {
            throw new IllegalArgumentException("The IntervalUnit: " + this.intervalUnit + " is invalid for this trigger.");
        }
        if (remainingMillisInDay - intervalInMillis <= 0L) {
            throw new IllegalArgumentException("The startTimeOfDay is too late with given Interval and IntervalUnit values.");
        }
        long maxNumOfCount = remainingMillisInDay / intervalInMillis;
        if ((long)count > maxNumOfCount) {
            throw new IllegalArgumentException("The given count " + count + " is too large! The max you can set is " + maxNumOfCount);
        }
        long incrementInMillis = (long)(count - 1) * intervalInMillis;
        long endTimeOfDayMillis = startTimeOfDayDateMillis + incrementInMillis;
        if (endTimeOfDayMillis > maxEndTimeOfDayDateMillis) {
            throw new IllegalArgumentException("The given count " + count + " is too large! The max you can set is " + maxNumOfCount);
        }
        LocalDateTime endLdt = DateUtil.ldt((long)endTimeOfDayMillis);
        this.endTimeOfDay = TimeOfDay.hourMinuteAndSecondOfDay((int)endLdt.getHour(), (int)endLdt.getMinute(), (int)endLdt.getSecond());
        return this;
    }

    public DailyTimeIntervalMonthScheduleBuilder withMisfireHandlingInstructionIgnoreMisfires() {
        this.misfireInstruction = -1;
        return this;
    }

    public DailyTimeIntervalMonthScheduleBuilder withMisfireHandlingInstructionDoNothing() {
        this.misfireInstruction = 2;
        return this;
    }

    public DailyTimeIntervalMonthScheduleBuilder withMisfireHandlingInstructionFireAndProceed() {
        this.misfireInstruction = 1;
        return this;
    }

    public DailyTimeIntervalMonthScheduleBuilder withRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
        return this;
    }

    private void validateInterval(int timeInterval) {
        if (timeInterval <= 0) {
            throw new IllegalArgumentException("Interval must be a positive value.");
        }
    }

    static {
        STARTING_DAILY = TimeOfDay.hourAndMinuteOfDay((int)0, (int)0);
        ENDING_DAILY = TimeOfDay.hourMinuteAndSecondOfDay((int)23, (int)59, (int)59);
        int maxDay = 31;
        HashSet<Integer> t = new HashSet<Integer>(31);
        for (int i = 1; i <= maxDay; ++i) {
            t.add(i);
        }
        ALL_DAYS_OF_THE_MONTH = Collections.unmodifiableSet(t);
    }
}

