package cn.sinozg.applet.quartz.config;

import cn.sinozg.applet.quartz.use.scheduler.SchedulerManager;
import com.alibaba.ttl.TtlRunnable;
import org.jetbrains.annotations.NotNull;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.Optional;

/**
* 定时任务 Configuration
* @Author: xyb
* @Description: 
* @Date: 2023-12-31 下午 12:14
**/
@Configuration
@ConditionalOnBean(QuartzMarker.class)
public class QuartzAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(QuartzAutoConfig.class);
    @Bean
    public SchedulerManager schedulerManager(Optional<Scheduler> scheduler) {
        if (!scheduler.isPresent()) {
            log.error("定时任务 - 已禁用");
            return new SchedulerManager(null);
        }
        return new SchedulerManager(scheduler.get());
    }

    @Bean
    public BeanPostProcessor threadPoolTaskExecutorBeanPostProcessor() {
        return new BeanPostProcessor() {
            @Override
            public Object postProcessBeforeInitialization(@NotNull Object bean, @NotNull String beanName) throws BeansException {
                if (!(bean instanceof ThreadPoolTaskExecutor)) {
                    return bean;
                }
                // 修改提交的任务，接入 TransmittableThreadLocal
                ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor) bean;
                // null
                // executor.setTaskDecorator(TtlRunnable::get);
                executor.setTaskDecorator(r -> TtlRunnable.get(() -> {}));
                return executor;
            }
        };
    }
}
