/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.quartz.use.util;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.common.utils.StringUtil;
import cn.sinozg.applet.quartz.use.enums.JobTypeEnum;
import cn.sinozg.applet.quartz.use.module.TaskScheduleModel;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.quartz.CronExpression;

public class CronUtils {
    public static boolean isValid(String cronExpression) {
        return CronExpression.isValidExpression((String)cronExpression);
    }

    public static List<LocalDateTime> getNextTimes(String cronExpression, int n) {
        CronExpression cron;
        try {
            cron = new CronExpression(cronExpression);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        Date now = new Date();
        ArrayList<LocalDateTime> nextTimes = new ArrayList<LocalDateTime>(n);
        for (int i = 0; i < n; ++i) {
            Date nextTime = cron.getNextValidTimeAfter(now);
            nextTimes.add(DateUtil.toLdt((long)nextTime.getTime()));
            now = nextTime;
        }
        return nextTimes;
    }

    public static String cronExpression(TaskScheduleModel model) {
        StringBuilder cron = new StringBuilder();
        JobTypeEnum type = model.getJobType();
        if (null == type) {
            throw new CavException("\u6267\u884c\u5468\u671f\u672a\u914d\u7f6e\uff01");
        }
        if (null == model.getSecond() && null == model.getMinute() && null == model.getHour()) {
            throw new CavException("\u65f6\u6216\u5206\u6216\u79d2\u53c2\u6570\u672a\u914d\u7f6e\uff01");
        }
        if (type.equals((Object)JobTypeEnum.SECOND) && model.getSecond() != null) {
            cron.append("0/").append(model.getSecond()).append(" * * * * ?");
        }
        if (type.equals((Object)JobTypeEnum.MINUTE) && model.getMinute() != null) {
            cron.append("* 0/").append(model.getMinute()).append(" * * * ?");
        }
        if (type.equals((Object)JobTypeEnum.HOUR) && model.getHour() != null) {
            cron.append("* * 0/").append(model.getHour()).append(" * * ?");
        }
        if (null != model.getSecond() && null != model.getMinute() && null != model.getHour()) {
            cron.append(model.getSecond()).append(" ").append(model.getMinute()).append(" ").append(model.getHour()).append(" ");
            if (type.equals((Object)JobTypeEnum.DAY)) {
                cron.append("* * ?");
            } else if (type.equals((Object)JobTypeEnum.WEEK)) {
                cron.append("? * ");
                CronUtils.days(cron, model.getDayOfWeeks());
            } else if (type.equals((Object)JobTypeEnum.MONTH)) {
                CronUtils.days(cron, model.getDayOfMonths());
                cron.append(" * ?");
            }
        }
        return cron.toString();
    }

    public static String createDescription(TaskScheduleModel model) {
        StringBuilder description = new StringBuilder();
        if (null != model.getSecond() && null != model.getMinute() && null != model.getHour()) {
            JobTypeEnum type = model.getJobType();
            if (type.equals((Object)JobTypeEnum.DAY)) {
                description.append("\u6bcf\u5929");
                description.append(model.getHour()).append("\u65f6");
                description.append(model.getMinute()).append("\u5206");
                description.append(model.getSecond()).append("\u79d2");
                description.append("\u6267\u884c");
            } else if (type.equals((Object)JobTypeEnum.WEEK)) {
                if (CollectionUtils.isNotEmpty(model.getDayOfWeeks())) {
                    StringBuilder days = new StringBuilder();
                    if (CronUtils.isAll(model.getDayOfWeeks())) {
                        days.append("\u6bcf\u5929");
                    } else {
                        for (int i : model.getDayOfWeeks()) {
                            days.append(i).append("\u5468");
                        }
                    }
                    description.append("\u6bcf\u5468\u7684").append((CharSequence)days).append(" ");
                }
                if (null != model.getSecond() && null != model.getMinute() && null != model.getHour()) {
                    description.append(",");
                    description.append(model.getHour()).append("\u65f6");
                    description.append(model.getMinute()).append("\u5206");
                    description.append(model.getSecond()).append("\u79d2");
                }
                description.append("\u6267\u884c");
            } else if (type.equals((Object)JobTypeEnum.MONTH)) {
                if (CollectionUtils.isNotEmpty(model.getDayOfMonths())) {
                    StringBuilder days = new StringBuilder();
                    if (CronUtils.isAll(model.getDayOfMonths())) {
                        days.append("\u6bcf\u5929");
                    } else {
                        for (int i : model.getDayOfMonths()) {
                            days.append(i).append("\u53f7");
                        }
                    }
                    description.append("\u6bcf\u6708\u7684").append((CharSequence)days).append(" ");
                }
                description.append(model.getHour()).append("\u65f6");
                description.append(model.getMinute()).append("\u5206");
                description.append(model.getSecond()).append("\u79d2");
                description.append("\u6267\u884c");
            }
        }
        return description.toString();
    }

    private static void days(StringBuilder cron, List<Integer> days) {
        if (CronUtils.isAll(days)) {
            cron.append("*");
        } else {
            days.forEach(d -> cron.append(",").append(d));
            StringUtil.delLast((StringBuilder)cron);
        }
    }

    private static boolean isAll(List<Integer> days) {
        return days.contains(0);
    }
}

