package cn.sinozg.applet.quartz.use.module;

import io.swagger.v3.oas.annotations.media.Schema;

import javax.validation.constraints.NotNull;
import java.time.LocalTime;

/**
 * 非 cron 类的周期任务 单次任务
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-11 12:40
 */
public class SchedulerCycleOnceParams extends SchedulerCycleParams {
    /** 单次任务执行时间 */
    @Schema(description = "单次任务执行时间")
    @NotNull(message = "执行时间不能为空！")
    private LocalTime runTime;

    /**
     * 获取 单次任务执行时间
     *
     * @return runTime 单次任务执行时间
     */
    public LocalTime getRunTime() {
        return this.runTime;
    }

    /**
     * 设置 单次任务执行时间
     *
     * @param runTime 单次任务执行时间
     */
    public void setRunTime(LocalTime runTime) {
        this.runTime = runTime;
    }
}
