/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.quartz.use.module;

import io.swagger.v3.oas.annotations.media.Schema;

import java.time.LocalDateTime;

/**
 * 单次任务
 * @Description 增加单次任务
 * @Copyright Copyright (c) 2024
 * @author xieyubin
 * @since 2024-05-25 22:07:47
 */
public class SchedulerSingleParams extends SchedulerBaseParams {
    /** 执行时间 */
    @Schema(description = "执行时间")
    private LocalDateTime singleTime;

    /**
     * 获取 执行时间
     *
     * @return singleTime 执行时间
     */
    public LocalDateTime getSingleTime() {
        return this.singleTime;
    }

    /**
     * 设置 执行时间
     *
     * @param singleTime 执行时间
     */
    public void setSingleTime(LocalDateTime singleTime) {
        this.singleTime = singleTime;
    }
}
