/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.quartz.use.enums;

/**
 * 定时任务操作
 * @Author: xyb
 * @Description:
 * @Date: 2023-12-31 下午 03:11
 **/
public enum JobOptEnum {
    /** 新增 */
    ADD("add", "新增"),
    /** 更新 */
    UPDATE("update", "更新"),
    /** 删除 */
    DEL("delete", "删除"),
    /** 启动 */
    RESUME("resume", "启动"),
    /** 暂停 */
    PAUSE("pause", "暂停"),
    ;
    private final String code;
    private final String name;

    JobOptEnum(String code, String name){
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
