/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.quartz.use.enums;

/**
 * Quartz Job Data 的 key 枚举
 *
 * @Author: xyb
 * @Description:
 * @Date: 2023-12-31 下午 12:08
 **/
public enum JobKeyEnum {

    /** job id */
    JOB_ID,
    /** job 名称 */
    JOB_NAME,
    /** job 实现类名称 */
    JOB_BEAN_NAME,
    /** job 参数 */
    JOB_ARGS,
    /** 租户 */
    JOB_TENANT,
    /** 最大重试次数 */
    JOB_RETRY_COUNT,
    /** 每次重试间隔 */
    JOB_RETRY_INTERVAL,
}
