/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.quartz.use.module;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;

import java.time.LocalDateTime;

/**
 * 任务基本信息
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-11 12:38
 */
public class SchedulerBaseParams {
    /** 主键id */
    @Schema(description = "主键id")
    private String id;

    /** 任务名称 */
    @Schema(description = "任务名称")
    @NotBlank(message = "任务名称不能为空！")
    private String jobName;

    /** 执行器的名称 */
    @Schema(description = "执行器的名称")
    @NotBlank(message = "执行器的名称不能为空！")
    private String beanName;

    /** 任务类型 01:周 02:月 03:cron 04:单次*/
    @Schema(description = "任务类型 01:周 02:月 03:cron 04:单次")
    @NotBlank(message = "任务类型不能为空！")
    private String jobType;

    /** 参数 */
    @Schema(description = "参数")
    private String args;

    /** 开始日期 */
    @Schema(description = "开始日期")
    private LocalDateTime beginDate;

    /** 结束日期 */
    @Schema(description = "结束日期")
    private LocalDateTime endDate;

    /** 重试次数 */
    @Schema(description = "重试次数")
    private Integer retryCount;

    /** 重试间隔 */
    @Schema(description = "重试间隔")
    private Integer retryInterval;

    /** 租户id */
    @JsonIgnore
    private String tenantId;

    /**
     * 获取 主键id
     *
     * @return id 主键id
     */
    public String getId() {
        return this.id;
    }

    /**
     * 设置 主键id
     *
     * @param id 主键id
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取 任务名称
     *
     * @return jobName 任务名称
     */
    public String getJobName() {
        return this.jobName;
    }

    /**
     * 设置 任务名称
     *
     * @param jobName 任务名称
     */
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    /**
     * 获取 执行器的名称
     *
     * @return beanName 执行器的名称
     */
    public String getBeanName() {
        return this.beanName;
    }

    /**
     * 设置 执行器的名称
     *
     * @param beanName 执行器的名称
     */
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    /**
     * 获取 任务类型 01:周 02:月 03:cron 04:单次
     *
     * @return jobType 任务类型 01:周 02:月 03:cron 04:单次
     */
    public String getJobType() {
        return this.jobType;
    }

    /**
     * 设置 任务类型 01:周 02:月 03:cron 04:单次
     *
     * @param jobType 任务类型 01:周 02:月 03:cron 04:单次
     */
    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    /**
     * 获取 参数
     *
     * @return args 参数
     */
    public String getArgs() {
        return this.args;
    }

    /**
     * 设置 参数
     *
     * @param args 参数
     */
    public void setArgs(String args) {
        this.args = args;
    }

    /**
     * 获取 开始日期
     *
     * @return beginDate 开始日期
     */
    public LocalDateTime getBeginDate() {
        return this.beginDate;
    }

    /**
     * 设置 开始日期
     *
     * @param beginDate 开始日期
     */
    public void setBeginDate(LocalDateTime beginDate) {
        this.beginDate = beginDate;
    }

    /**
     * 获取 结束日期
     *
     * @return endDate 结束日期
     */
    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    /**
     * 设置 结束日期
     *
     * @param endDate 结束日期
     */
    public void setEndDate(LocalDateTime endDate) {
        this.endDate = endDate;
    }

    /**
     * 获取 重试次数
     *
     * @return retryCount 重试次数
     */
    public Integer getRetryCount() {
        return this.retryCount;
    }

    /**
     * 设置 重试次数
     *
     * @param retryCount 重试次数
     */
    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    /**
     * 获取 重试间隔
     *
     * @return retryInterval 重试间隔
     */
    public Integer getRetryInterval() {
        return this.retryInterval;
    }

    /**
     * 设置 重试间隔
     *
     * @param retryInterval 重试间隔
     */
    public void setRetryInterval(Integer retryInterval) {
        this.retryInterval = retryInterval;
    }

    /**
     * 获取 租户id
     *
     * @return tenantId 租户id
     */
    public String getTenantId() {
        return this.tenantId;
    }

    /**
     * 设置 租户id
     *
     * @param tenantId 租户id
     */
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }
}
