/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.quartz.use.module;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;


/**
 * cron 类型的任务
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-11 12:38
 */
public class SchedulerCronParams extends SchedulerBaseParams {
    /** 任务表达式 */
    @Schema(description = "任务表达式")
    @NotBlank(message = "任务表达式不能为空！")
    private String cron;

    /**
     * 获取 任务表达式
     *
     * @return cron 任务表达式
     */
    public String getCron() {
        return this.cron;
    }

    /**
     * 设置 任务表达式
     *
     * @param cron 任务表达式
     */
    public void setCron(String cron) {
        this.cron = cron;
    }
}
