/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.quartz.use.module;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;

import java.time.LocalTime;

/**
 * 非 cron 类的周期任务 多次任务
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-11 12:40
 */
public class SchedulerCycleTimesParams extends SchedulerCycleParams {

    /** 延迟任务开始时间 */
    @Schema(description = "延迟任务开始时间")
    @NotNull(message = "{TIRSCI.Scheduler.beginTime}")
    private LocalTime beginTime;

    /** 延迟任务结束时间 */
    @Schema(description = "延迟任务结束时间")
    @NotNull(message = "{TIRSCI.Scheduler.endTime}")
    private LocalTime endTime;

    /** 延迟数 */
    @Schema(description = "延迟数")
    @NotNull(message = "{TIRSCI.Scheduler.intervalTime}")
    private Integer intervalTime;

    /** 延迟单位 01:秒 02:分 03:时 */
    @Schema(description = "延迟单位 01:秒 02:分 03:时")
    @NotNull(message = "{TIRSCI.Scheduler.intervalUnit}")
    private String intervalUnit;

    /**
     * 获取 延迟任务开始时间
     *
     * @return beginTime 延迟任务开始时间
     */
    public LocalTime getBeginTime() {
        return this.beginTime;
    }

    /**
     * 设置 延迟任务开始时间
     *
     * @param beginTime 延迟任务开始时间
     */
    public void setBeginTime(LocalTime beginTime) {
        this.beginTime = beginTime;
    }

    /**
     * 获取 延迟任务结束时间
     *
     * @return endTime 延迟任务结束时间
     */
    public LocalTime getEndTime() {
        return this.endTime;
    }

    /**
     * 设置 延迟任务结束时间
     *
     * @param endTime 延迟任务结束时间
     */
    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    /**
     * 获取 延迟数
     *
     * @return intervalTime 延迟数
     */
    public Integer getIntervalTime() {
        return this.intervalTime;
    }

    /**
     * 设置 延迟数
     *
     * @param intervalTime 延迟数
     */
    public void setIntervalTime(Integer intervalTime) {
        this.intervalTime = intervalTime;
    }

    /**
     * 获取 延迟单位 01:秒 02:分 03:时
     *
     * @return intervalUnit 延迟单位 01:秒 02:分 03:时
     */
    public String getIntervalUnit() {
        return this.intervalUnit;
    }

    /**
     * 设置 延迟单位 01:秒 02:分 03:时
     *
     * @param intervalUnit 延迟单位 01:秒 02:分 03:时
     */
    public void setIntervalUnit(String intervalUnit) {
        this.intervalUnit = intervalUnit;
    }
}
