/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.quartz.use.module;

import cn.sinozg.applet.common.annotation.EnumField;
import cn.sinozg.applet.quartz.use.enums.JobTypeEnum;
import io.swagger.v3.oas.annotations.media.Schema;

import java.util.List;

/**
 * cron 生成 参数
 *
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-10 15:20
 */
public class TaskScheduleModel {
    /**
     * 所选作业类型
     */
    @Schema(description = "所选作业类型")
    @EnumField(clazz = JobTypeEnum.class)
    private JobTypeEnum jobType;

    /**
     * 一周的哪几天
     */
    @Schema(description = "一周的哪几天 0 表示所有")
    private List<Integer> dayOfWeeks;

    /**
     * 一个月的哪几天
     */
    @Schema(description = "一个月的哪几天 0 表示所有")
    private List<Integer> dayOfMonths;

    /**
     * 秒
     */
    @Schema(description = "秒")
    private Integer second;

    /**
     * 分
     */
    @Schema(description = "分")
    private Integer minute;

    /**
     * 时
     */
    @Schema(description = "时")
    private Integer hour;

    /**
     * 获取 所选作业类型
     *
     * @return jobType 所选作业类型
     */
    public JobTypeEnum getJobType() {
        return this.jobType;
    }

    /**
     * 设置 所选作业类型
     *
     * @param jobType 所选作业类型
     */
    public void setJobType(JobTypeEnum jobType) {
        this.jobType = jobType;
    }

    /**
     * 获取 一周的哪几天
     *
     * @return dayOfWeeks 一周的哪几天
     */
    public List<Integer> getDayOfWeeks() {
        return this.dayOfWeeks;
    }

    /**
     * 设置 一周的哪几天
     *
     * @param dayOfWeeks 一周的哪几天
     */
    public void setDayOfWeeks(List<Integer> dayOfWeeks) {
        this.dayOfWeeks = dayOfWeeks;
    }

    /**
     * 获取 一个月的哪几天
     *
     * @return dayOfMonths 一个月的哪几天
     */
    public List<Integer> getDayOfMonths() {
        return this.dayOfMonths;
    }

    /**
     * 设置 一个月的哪几天
     *
     * @param dayOfMonths 一个月的哪几天
     */
    public void setDayOfMonths(List<Integer> dayOfMonths) {
        this.dayOfMonths = dayOfMonths;
    }

    /**
     * 获取 秒
     *
     * @return second 秒
     */
    public Integer getSecond() {
        return this.second;
    }

    /**
     * 设置 秒
     *
     * @param second 秒
     */
    public void setSecond(Integer second) {
        this.second = second;
    }

    /**
     * 获取 分
     *
     * @return minute 分
     */
    public Integer getMinute() {
        return this.minute;
    }

    /**
     * 设置 分
     *
     * @param minute 分
     */
    public void setMinute(Integer minute) {
        this.minute = minute;
    }

    /**
     * 获取 时
     *
     * @return hour 时
     */
    public Integer getHour() {
        return this.hour;
    }

    /**
     * 设置 时
     *
     * @param hour 时
     */
    public void setHour(Integer hour) {
        this.hour = hour;
    }
}
