/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.quartz.use.module;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;

import java.time.LocalTime;

/**
 * 非 cron 类的周期任务 单次任务
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-11 12:40
 */
public class SchedulerCycleOnceParams extends SchedulerCycleParams {
    /** 单次任务执行时间 */
    @Schema(description = "单次任务执行时间")
    @NotNull(message = "{TIRSCI.Scheduler.runTime}")
    private LocalTime runTime;

    /**
     * 获取 单次任务执行时间
     *
     * @return runTime 单次任务执行时间
     */
    public LocalTime getRunTime() {
        return this.runTime;
    }

    /**
     * 设置 单次任务执行时间
     *
     * @param runTime 单次任务执行时间
     */
    public void setRunTime(LocalTime runTime) {
        this.runTime = runTime;
    }
}
