/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.quartz.use.service;

import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;

import java.time.LocalDateTime;

/**
 * 定时任务日志记录
 * @Author: xyb
 * @Description:
 * @Date: 2023-12-30 下午 11:42
 **/
public interface JobLogBaseService {

    /**
     * 创建 Job 日志
     *
     * @param jobId           任务编号
     * @param jobName       任务名称
     * @param beginTime       开始时间
     * @param beanName  Job 处理器的名字
     * @param args Job 处理器的参数
     * @param exeIndex    第几次执行
     * @return id
     */
    String createJobLog(@NotNull(message = "任务编号不能为空") String jobId, String jobName,
                        @NotNull(message = "开始时间") LocalDateTime beginTime,
                        @NotEmpty(message = "Job 处理器的名字不能为空") String beanName,
                        String args,
                        @NotNull(message = "第几次执行不能为空") Integer exeIndex);

    /**
     * 更新 Job 日志的执行结果
     *
     * @param logId    日志编号
     * @param endTime  结束时间。因为是异步，避免记录时间不准去
     * @param success  是否成功
     * @param result   成功数据
     */
    void updateJobLogResultAsync(@NotNull(message = "日志编号不能为空") String logId, @NotNull(message = "结束时间不能为空") LocalDateTime endTime,
                                 boolean success, String result);
}
