/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.quartz.config;

import cn.sinozg.applet.quartz.config.QuartzMarker;
import cn.sinozg.applet.quartz.use.scheduler.SchedulerManager;
import com.alibaba.ttl.TtlRunnable;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@ConditionalOnBean(value={QuartzMarker.class})
public class QuartzAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(QuartzAutoConfig.class);

    @Bean
    public SchedulerManager schedulerManager(Optional<Scheduler> scheduler) {
        if (scheduler.isEmpty()) {
            log.error("\u5b9a\u65f6\u4efb\u52a1 - \u5df2\u7981\u7528");
            return new SchedulerManager(null);
        }
        return new SchedulerManager(scheduler.get());
    }

    @Bean
    public BeanPostProcessor threadPoolTaskExecutorBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(@NotNull Object bean, @NotNull String beanName) throws BeansException {
                if (!(bean instanceof ThreadPoolTaskExecutor)) {
                    return bean;
                }
                ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)bean;
                executor.setTaskDecorator(r -> TtlRunnable.get(() -> {}));
                return executor;
            }
        };
    }
}

