/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.license;

import cn.sinozg.applet.common.utils.CypherUtil;
import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.common.utils.StringUtil;
import cn.sinozg.applet.license.model.CustomKeyStoreParam;
import cn.sinozg.applet.license.model.LicenseCheckModel;
import cn.sinozg.applet.license.model.LicenseVerifyParams;
import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.DefaultCipherParam;
import de.schlichtherle.license.DefaultLicenseParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContentException;
import de.schlichtherle.license.LicenseNotaryException;
import de.schlichtherle.license.LicenseParam;
import de.schlichtherle.license.NoLicenseInstalledException;
import de.schlichtherle.util.ObfuscatedString;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;

public class LicenseUtil {
    private static final String S = new ObfuscatedString(new long[]{5169219316992127029L, 4388583503819972773L, -4993129809183285509L, -4161106043945402605L, -1127721099684436933L, 5209999802060679502L, 7137738139453654624L, 863850526866531015L, -2729560261826027937L, -5964236127309761856L, -7942665976186621307L, 857611772304303580L, -5269336192730602315L, -8036760472895127283L, 64502694572040173L, 4736691709942628612L, -8058738850739401751L, 8092520492041562325L, -4069660239427234318L, -6231839935726727405L, -8861625179141599064L, 1707429252702505069L, -6661895788814551444L, -8487444736278127059L, 1477011093063522368L, -6474683425098696705L, 1065507054846573976L, 7091495226300292241L}).toString();

    public static LocalDateTime toLdt(Date date) {
        return DateUtil.ldt((long)date.getTime());
    }

    public static Date toDate(LocalDateTime ldt) {
        return Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static boolean sing(LicenseCheckModel model) {
        return CypherUtil.signature((boolean)true, (String)model.getSign(), (String[])new String[]{S, model.getCpuSerial(), model.getMainBoardSerial(), LicenseUtil.join(model.getIpAddress()), LicenseUtil.join(model.getMacAddress())});
    }

    public static String join(List<String> list) {
        return (String)StringUtils.defaultIfBlank((CharSequence)StringUtil.join(list), (CharSequence)"@");
    }

    public static String errorMessage(Exception e) {
        String error = e.getMessage();
        if (StringUtils.isNotBlank((CharSequence)error) && Character.isLowerCase(error.charAt(0))) {
            if (e instanceof LicenseContentException) {
                LicenseContentException lc = (LicenseContentException)e;
                error = lc.getLocalizedMessage();
            } else if (e instanceof LicenseNotaryException) {
                LicenseNotaryException lc = (LicenseNotaryException)e;
                error = lc.getLocalizedMessage();
            } else if (e instanceof NoLicenseInstalledException) {
                NoLicenseInstalledException lc = (NoLicenseInstalledException)e;
                error = lc.getLocalizedMessage();
            }
        }
        return error;
    }

    public static InputStream streamByPath(String path) throws IOException {
        String prefix = "classpath:";
        if (StringUtils.contains((CharSequence)path, (CharSequence)prefix)) {
            ClassPathResource resource = new ClassPathResource(StringUtils.replace((String)path, (String)prefix, (String)""));
            return resource.getInputStream();
        }
        return new FileInputStream(path);
    }

    public static LicenseParam licenseParam(Class<?> clazz, LicenseVerifyParams params) {
        Preferences preferences = Preferences.userNodeForPackage(clazz);
        DefaultCipherParam param = new DefaultCipherParam(params.getPass());
        CustomKeyStoreParam storeParam = new CustomKeyStoreParam(clazz, params);
        return new DefaultLicenseParam(params.getSubject(), preferences, (KeyStoreParam)storeParam, (CipherParam)param);
    }
}

