/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.license.core;

import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.license.LicenseUtil;
import cn.sinozg.applet.license.core.CustomLicenseNotary;
import cn.sinozg.applet.license.model.LicenseCheckModel;
import cn.sinozg.applet.license.model.LicenseVerifyParams;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseContentException;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseNotary;
import de.schlichtherle.license.NoLicenseInstalledException;
import de.schlichtherle.xml.GenericCertificate;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLicenseManager
extends LicenseManager {
    private static LicenseNotary licenseNotary;
    private static LicenseCheckModel licenseCheckModel;
    private static final Logger log;

    public CustomLicenseManager(Class<?> clazz, LicenseVerifyParams params) {
        super(LicenseUtil.licenseParam(clazz, params));
        if (licenseNotary == null) {
            licenseNotary = new CustomLicenseNotary(this.getLicenseParam().getKeyStoreParam());
        }
    }

    public synchronized LicenseContent install(String path) throws Exception {
        LicenseNotary licenseNotary = this.getLicenseNotary();
        byte[] bs = IOUtils.toByteArray((InputStream)LicenseUtil.streamByPath(path));
        return this.install(bs, licenseNotary);
    }

    protected synchronized byte[] create(LicenseContent content, LicenseNotary notary) throws Exception {
        this.initialize(content);
        this.validateCreate(content);
        GenericCertificate certificate = licenseNotary.sign((Object)content);
        return this.getPrivacyGuard().cert2key(certificate);
    }

    protected synchronized LicenseContent install(byte[] key, LicenseNotary notary) throws Exception {
        GenericCertificate certificate = this.getPrivacyGuard().key2cert(key);
        licenseNotary.verify(certificate);
        LicenseContent content = (LicenseContent)certificate.getContent();
        this.validate(content);
        this.validateSign(content);
        this.setLicenseKey(key);
        this.setCertificate(certificate);
        return content;
    }

    protected synchronized LicenseContent verify(LicenseNotary notary) throws Exception {
        byte[] key = this.getLicenseKey();
        if (null == key) {
            throw new NoLicenseInstalledException(this.getLicenseParam().getSubject());
        }
        GenericCertificate certificate = this.getPrivacyGuard().key2cert(key);
        licenseNotary.verify(certificate);
        LicenseContent content = (LicenseContent)certificate.getContent();
        this.validate(content);
        this.setCertificate(certificate);
        return content;
    }

    protected synchronized void validate(LicenseContent content) throws LicenseContentException {
        LicenseCheckModel serverModel;
        super.validate(content);
        Object extra = content.getExtra();
        if (extra == null) {
            return;
        }
        LicenseCheckModel model = (LicenseCheckModel)extra;
        if (licenseCheckModel == null) {
            licenseCheckModel = new LicenseCheckModel();
        }
        if (StringUtils.isBlank((CharSequence)(serverModel = licenseCheckModel).getMainBoardSerial())) {
            throw new LicenseContentException("\u4e0d\u80fd\u83b7\u53d6\u670d\u52a1\u5668\u786c\u4ef6\u4fe1\u606f");
        }
        if (this.checkIpAddress(model.getIpAddress(), serverModel.getIpAddress())) {
            throw new LicenseContentException("\u5f53\u524d\u670d\u52a1\u5668\u7684IP\u6ca1\u5728\u6388\u6743\u8303\u56f4\u5185");
        }
        if (this.checkIpAddress(model.getMacAddress(), serverModel.getMacAddress())) {
            throw new LicenseContentException("\u5f53\u524d\u670d\u52a1\u5668\u7684Mac\u5730\u5740\u6ca1\u5728\u6388\u6743\u8303\u56f4\u5185");
        }
        if (this.checkSerial(model.getMainBoardSerial(), serverModel.getMainBoardSerial())) {
            throw new LicenseContentException("\u5f53\u524d\u670d\u52a1\u5668\u7684\u4e3b\u677f\u5e8f\u5217\u53f7\u6ca1\u5728\u6388\u6743\u8303\u56f4\u5185");
        }
        if (this.checkSerial(model.getCpuSerial(), serverModel.getCpuSerial())) {
            throw new LicenseContentException("\u5f53\u524d\u670d\u52a1\u5668\u7684CPU\u5e8f\u5217\u53f7\u6ca1\u5728\u6388\u6743\u8303\u56f4\u5185");
        }
    }

    private void validateSign(LicenseContent content) throws LicenseContentException {
        LicenseCheckModel model;
        boolean success;
        if (content != null && !(success = LicenseUtil.sing(model = (LicenseCheckModel)content.getExtra()))) {
            throw new LicenseContentException("\u975e\u6cd5\u8bc1\u4e66\uff01");
        }
    }

    protected synchronized void validateCreate(LicenseContent content) throws LicenseContentException {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime notBefore = DateUtil.ldt((long)content.getNotBefore().getTime());
        LocalDateTime notAfter = DateUtil.ldt((long)content.getNotAfter().getTime());
        if (null != notAfter && now.isAfter(notAfter)) {
            throw new LicenseContentException("\u8bc1\u4e66\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        if (null != notBefore && null != notAfter && notAfter.isBefore(notBefore)) {
            throw new LicenseContentException("\u8bc1\u4e66\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u8bc1\u4e66\u5931\u6548\u65f6\u95f4");
        }
        if (StringUtils.isBlank((CharSequence)content.getConsumerType())) {
            throw new LicenseContentException("\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private boolean checkIpAddress(List<String> expectedList, List<String> serverList) {
        if (CollectionUtils.isNotEmpty(expectedList)) {
            return expectedList.stream().map(String::trim).noneMatch(serverList::contains);
        }
        return false;
    }

    private boolean checkSerial(String expectedSerial, String serverSerial) {
        return StringUtils.isNotBlank((CharSequence)expectedSerial) && !expectedSerial.equals(serverSerial);
    }

    static {
        log = LoggerFactory.getLogger(CustomLicenseManager.class);
    }
}

