/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.license.core;

import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.common.utils.MsgUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.license.LicenseUtil;
import cn.sinozg.applet.license.core.CustomLicenseManager;
import cn.sinozg.applet.license.core.LicenseManagerHolder;
import cn.sinozg.applet.license.model.LicenseVerifyParams;
import cn.sinozg.applet.license.properties.LicenseProperties;
import de.schlichtherle.license.LicenseContent;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseVerify {
    private static final Logger log = LoggerFactory.getLogger(LicenseVerify.class);
    private static final AtomicInteger ERROR_COUNT = new AtomicInteger(0);

    public static synchronized boolean installWithConfig(LicenseProperties properties) {
        LicenseVerifyParams params = (LicenseVerifyParams)PojoUtil.copyBean((Object)properties, LicenseVerifyParams.class);
        try {
            CustomLicenseManager manager = LicenseManagerHolder.getInstance(LicenseVerify.class, params);
            manager.uninstall();
            LicenseContent content = manager.install(params.getPath());
            log.info("\u8bc1\u4e66\u5b89\u88c5\u6210\u529f\uff0c\u8bc1\u4e66\u6709\u6548\u671f\uff1a{} - {}", (Object)DateUtil.formatDateTime((LocalDateTime)LicenseUtil.toLdt(content.getNotBefore())), (Object)DateUtil.formatDateTime((LocalDateTime)LicenseUtil.toLdt(content.getNotAfter())));
            return true;
        }
        catch (Exception e) {
            String error = LicenseUtil.errorMessage(e);
            log.error("\u8bc1\u4e66\u5b89\u88c5\u5931\u8d25\uff0c{}\uff0c\u51c6\u5907\u9000\u51fa\u5e94\u7528\uff01", (Object)error);
            MsgUtil.printCause((Throwable)e.getCause(), (StackTraceElement[])e.getStackTrace());
            System.exit(0);
            return false;
        }
    }

    public static boolean verify(LicenseProperties properties) {
        CustomLicenseManager manager = LicenseManagerHolder.getInstance(null, null);
        try {
            LicenseContent content = manager.verify();
            if (log.isDebugEnabled()) {
                log.debug("\u8bc1\u4e66\u68c0\u9a8c\u6210\u529f\uff0c\u8bc1\u4e66\u6709\u6548\u671f\uff1a{} - {}", (Object)DateUtil.formatDateTime((LocalDateTime)LicenseUtil.toLdt(content.getNotBefore())), (Object)DateUtil.formatDateTime((LocalDateTime)LicenseUtil.toLdt(content.getNotAfter())));
            }
            return true;
        }
        catch (Exception e) {
            boolean success;
            log.error("\u8bc1\u4e66\u68c0\u9a8c\u5931\u8d25\uff01", (Throwable)e);
            if (ERROR_COUNT.incrementAndGet() < 20 && (success = LicenseVerify.installWithConfig(properties))) {
                ERROR_COUNT.set(0);
            }
            return false;
        }
    }
}

