/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.license.model;

import cn.sinozg.applet.common.utils.CypherUtil;
import cn.sinozg.applet.license.LicenseUtil;
import cn.sinozg.applet.license.core.CustomLicenseManager;
import cn.sinozg.applet.license.model.LicenseCheckModel;
import cn.sinozg.applet.license.model.LicenseCreateParams;
import cn.sinozg.applet.license.model.LicenseVerifyParams;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.util.ObfuscatedString;
import java.io.File;
import java.time.LocalDateTime;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseCreator {
    private static final Logger log = LoggerFactory.getLogger(LicenseCreator.class);
    private static final X500Principal DEFAULT_PRINCIPAL = new X500Principal("CN=sinozg.cn, OU=sinozg, O=sinozg, L=WH, ST=HB, C=CN");
    private static final String S = new ObfuscatedString(new long[]{5169219316992127029L, 4388583503819972773L, -4993129809183285509L, -4161106043945402605L, -1127721099684436933L, 5209999802060679502L, 7137738139453654624L, 863850526866531015L, -2729560261826027937L, -5964236127309761856L, -7942665976186621307L, 857611772304303580L, -5269336192730602315L, -8036760472895127283L, 64502694572040173L, 4736691709942628612L, -8058738850739401751L, 8092520492041562325L, -4069660239427234318L, -6231839935726727405L, -8861625179141599064L, 1707429252702505069L, -6661895788814551444L, -8487444736278127059L, 1477011093063522368L, -6474683425098696705L, 1065507054846573976L, 7091495226300292241L}).toString();

    public boolean createLicense(LicenseCreateParams params) {
        try {
            CustomLicenseManager manager = new CustomLicenseManager(LicenseCreator.class, (LicenseVerifyParams)params);
            LicenseContent content = this.licenseContent(params);
            manager.store(content, new File(params.getPath()));
            return true;
        }
        catch (Exception e) {
            log.error("\u8bc1\u4e66\u751f\u6210\u5931\u8d25\uff1a{}", (Object)LicenseUtil.errorMessage((Exception)e));
            return false;
        }
    }

    private LicenseContent licenseContent(LicenseCreateParams params) {
        LicenseContent content = new LicenseContent();
        content.setHolder(DEFAULT_PRINCIPAL);
        content.setIssuer(DEFAULT_PRINCIPAL);
        content.setSubject(params.getSubject());
        content.setIssued(LicenseUtil.toDate((LocalDateTime)params.getIssued()));
        content.setNotBefore(LicenseUtil.toDate((LocalDateTime)params.getIssued()));
        content.setNotAfter(LicenseUtil.toDate((LocalDateTime)params.getExpiry()));
        content.setConsumerType(params.getType());
        content.setConsumerAmount(params.getAmount().intValue());
        content.setInfo(params.getDesc());
        LicenseCheckModel model = params.getCheckModel();
        if (model == null) {
            model = new LicenseCheckModel();
        }
        String sign = CypherUtil.signMessage((boolean)true, (String[])new String[]{S, model.getCpuSerial(), model.getMainBoardSerial(), LicenseUtil.join((List)model.getIpAddress()), LicenseUtil.join((List)model.getMacAddress())});
        model.setSign(sign);
        content.setExtra((Object)model);
        return content;
    }
}

