/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.biz.monthly.config;

import cn.sinozg.applet.biz.monthly.handler.MonthlyTableHandler;
import cn.sinozg.applet.biz.monthly.properties.MonthlyTableInfo;
import cn.sinozg.applet.biz.monthly.properties.MonthlyTableProperties;
import cn.sinozg.applet.biz.monthly.service.MonthlyTableService;
import cn.sinozg.applet.common.service.FrameworkInitRunService;
import cn.sinozg.applet.common.utils.PojoUtil;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TableNameHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.DynamicTableNameInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import jakarta.annotation.Resource;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="app.mt", name={"enabled"}, havingValue="true")
public class MonthlyTableConfiguration
implements FrameworkInitRunService {
    private static final Logger log = LoggerFactory.getLogger(MonthlyTableConfiguration.class);
    @Resource
    private MonthlyTableProperties monthlyTableProperties;
    @Resource
    private MybatisPlusInterceptor mybatisPlusInterceptor;
    @Resource
    private MonthlyTableService monthlyTableService;

    public void initInfo() {
        List<MonthlyTableInfo> tableInfos = this.monthlyTableProperties.getTables();
        if (CollectionUtils.isEmpty(tableInfos)) {
            log.error("\u672a\u914d\u7f6e\u9700\u8981\u6708\u4efd\u52a8\u6001\u751f\u6210\u8868\u7684\u4fe1\u606f");
            return;
        }
        List list = PojoUtil.toList(tableInfos, MonthlyTableInfo::getTm);
        DynamicTableNameInnerInterceptor interceptor = new DynamicTableNameInnerInterceptor((TableNameHandler)new MonthlyTableHandler(list));
        this.mybatisPlusInterceptor.addInnerInterceptor((InnerInterceptor)interceptor);
        this.monthlyTableService.dropMonthlyTable();
        this.monthlyTableService.createMonthlyTable(0);
    }
}

