/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.biz.monthly.service.impl;

import cn.sinozg.applet.biz.monthly.mapper.MonthlyTableMapper;
import cn.sinozg.applet.biz.monthly.model.CreateTableParams;
import cn.sinozg.applet.biz.monthly.properties.MonthlyTableInfo;
import cn.sinozg.applet.biz.monthly.properties.MonthlyTableProperties;
import cn.sinozg.applet.biz.monthly.service.MonthlyTableService;
import cn.sinozg.applet.biz.monthly.util.MonthlyTableUtil;
import jakarta.annotation.Resource;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MonthlyTableServiceImpl
implements MonthlyTableService {
    @Resource
    private MonthlyTableProperties properties;
    @Resource
    private MonthlyTableMapper monthlyTableMapper;
    private static final int DEFAULT_MONTHLY = -6;
    private static final Logger log = LoggerFactory.getLogger(MonthlyTableServiceImpl.class);

    @Override
    public void createMonthlyTable(int add) {
        List<MonthlyTableInfo> tables = this.properties.getTables();
        if (CollectionUtils.isEmpty(tables)) {
            log.error("\u672a\u8bbe\u7f6e\u8868\u4fe1\u606f\uff01");
            return;
        }
        for (MonthlyTableInfo table : tables) {
            String tableName = table.getTm();
            CreateTableParams params = new CreateTableParams();
            params.setTableName(tableName);
            params.setNewTableName(MonthlyTableUtil.tableName(add, tableName));
            this.monthlyTableMapper.createMonthlyTable(params);
        }
    }

    @Override
    public void dropMonthlyTable() {
        List<MonthlyTableInfo> tables = this.properties.getTables();
        if (CollectionUtils.isNotEmpty(tables)) {
            for (MonthlyTableInfo table : tables) {
                Integer dropTime = table.getDropTime();
                if (dropTime == null || dropTime > 0) {
                    dropTime = -6;
                }
                this.monthlyTableMapper.dropMonthlyTable(MonthlyTableUtil.tableName(dropTime, table.getTm()));
            }
        }
    }

    @Override
    public boolean existsTable(String tableName, int add) {
        return this.monthlyTableMapper.existsMonthlyTable(MonthlyTableUtil.tableName(add, tableName));
    }
}

