/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.mq.vertx.handle;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.mq.joint.BaseTopicType;
import cn.sinozg.applet.mq.mq.MqProducer;
import cn.sinozg.applet.mq.vertx.VertxManager;
import cn.sinozg.applet.mq.vertx.verticle.ProducerVerticle;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxMqProducer<T>
implements MqProducer<T> {
    private final ProducerVerticle<T> producerVerticle;
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private static final Logger log = LoggerFactory.getLogger(VertxMqProducer.class);

    public VertxMqProducer(Class<T> clazz) {
        this.producerVerticle = new ProducerVerticle<T>(clazz);
        VertxManager.instance().deployVerticle(this.producerVerticle, stringAsyncResult -> this.countDownLatch.countDown());
        try {
            this.countDownLatch.await();
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316 VertxMqProducer \u5931\u8d25\uff01", (Throwable)e);
            throw new CavException("\u521d\u59cb\u5316 VertxMqProducer \u5931\u8d25\uff01");
        }
    }

    public void publish(BaseTopicType topic, T msg) {
        this.producerVerticle.publish(topic.topic(), msg);
    }

    public void publish(String topic, T msg) {
        this.producerVerticle.publish(topic, msg);
    }
}

