/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.mq.vertx.handle;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.mq.handle.ConsumerHandler;
import cn.sinozg.applet.mq.joint.BaseTopicType;
import cn.sinozg.applet.mq.mq.MqConsumer;
import cn.sinozg.applet.mq.vertx.VertxManager;
import cn.sinozg.applet.mq.vertx.verticle.ConsumerVerticle;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxMqConsumer<T>
implements MqConsumer<T> {
    private final ConsumerVerticle<T> consumerVerticle;
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private static final Logger log = LoggerFactory.getLogger(VertxMqConsumer.class);

    public VertxMqConsumer(Class<T> clazz) {
        this.consumerVerticle = new ConsumerVerticle<T>(clazz);
        VertxManager.instance().deployVerticle(this.consumerVerticle).onComplete(h -> this.countDownLatch.countDown());
        try {
            this.countDownLatch.await();
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316 VertxMqConsumer \u5931\u8d25\uff01", (Throwable)e);
            throw new CavException("BIZ000100058");
        }
    }

    public void consume(BaseTopicType topic, ConsumerHandler<T> handler) {
        this.consumerVerticle.consume(topic.topic(), handler);
    }

    public void consume(String topic, ConsumerHandler<T> handler) {
        this.consumerVerticle.consume(topic, handler);
    }
}

