/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.mq.service;

import cn.sinozg.applet.common.service.FrameworkInitRunService;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.SpringUtil;
import cn.sinozg.applet.mq.handle.ConsumerAutoHandler;
import cn.sinozg.applet.mq.mq.MqConsumer;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 自动消费 实现了
 * @see ConsumerAutoHandler 的类
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-18 19:20
 */
@Service
public class AutoConsumerServiceImpl implements FrameworkInitRunService {

    @Override
    public void initInfo() {
        Map<String, ConsumerAutoHandler<Object>> map = PojoUtil.cast(SpringUtil.beansOfType(ConsumerAutoHandler.class));
        for (Map.Entry<String, ConsumerAutoHandler<Object>> e : map.entrySet()) {
            ConsumerAutoHandler<Object> handler = e.getValue();
            handler.initialization();
            MqConsumer<Object> consumer = handler.consumer();
            if (consumer != null) {
                consumer.consume(handler.type(), handler);
            }
        }
    }
}
