/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.mq.mq;

import cn.sinozg.applet.mq.joint.BaseTopicType;

/**
 * 生产者 发布消息
 * @Description
 * @Copyright Copyright (c) 2023
 * @author xieyubin
 * @since 2023-11-16 16:29:12
 */
public interface MqProducer<T> {

    /**
     * 发布消息 限制业务的类型
     * @param topic topic
     * @param msg msg
     */
    void publish(BaseTopicType topic, T msg);

    /**
     * 发布消息
     * @param topic topic
     * @param msg msg
     */
    void publish(String topic, T msg);
}
