/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.mqtt.service.impl;

import cn.sinozg.applet.mqtt.component.MqttProtocolComponent;
import cn.sinozg.applet.mqtt.model.MqttMessageInfo;
import cn.sinozg.applet.mqtt.model.MqttServerConfig;
import cn.sinozg.applet.mqtt.service.MqttSendCaseService;
import cn.sinozg.applet.mqtt.service.SubscribeService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MqttSendServiceImpl
implements MqttSendCaseService {
    @Resource
    private SubscribeService mqttSubscribeService;
    private MqttProtocolComponent component;
    private static final Logger log = LoggerFactory.getLogger(MqttSendServiceImpl.class);

    @Override
    public void init(MqttServerConfig config) {
        if (config.isDisable()) {
            log.info("\u4e0d\u542f\u52a8mqtt ");
            return;
        }
        this.component = new MqttProtocolComponent();
        this.component.create(config, this.mqttSubscribeService);
        this.component.start();
        log.info("\u542f\u52a8 vertx report ..... ");
    }

    @Override
    public void stop() {
        this.component.stop();
    }

    @Override
    public boolean send(MqttMessageInfo message) {
        return this.component.send(message);
    }

    @Override
    public void send(String topic, Object message) {
        log.info("\u53d1\u5e03\u6307\u4ee4\u6d88\u606f\uff0c{} {}", (Object)topic, message);
        this.send(new MqttMessageInfo(topic, message));
    }
}

