/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.mqtt.util;

import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class MqttTopic {
    private static final int INDEX_NOT_FOUND = -1;
    public static final String TOPIC_LEVEL_SEPARATOR = "/";
    public static final String MULTI_LEVEL_WILDCARD = "#";
    public static final String SINGLE_LEVEL_WILDCARD = "+";
    public static final String MULTI_LEVEL_WILDCARD_PATTERN = "/#";
    public static final String TOPIC_WILDCARDS = "#+";
    private static final int MIN_TOPIC_LEN = 1;
    private static final int MAX_TOPIC_LEN = 65535;
    private static final char NUL = '\u0000';

    public static void validate(String topicString, boolean wildcardAllowed) throws IllegalArgumentException {
        int topicLen = topicString.getBytes(StandardCharsets.UTF_8).length;
        if (topicLen < 1 || topicLen > 65535) {
            throw new IllegalArgumentException(String.format("Invalid topic length, should be in range[%d, %d]!", 1, 65535));
        }
        if (wildcardAllowed) {
            boolean multi;
            if (StringUtils.equalsAny((CharSequence)topicString, (CharSequence[])new CharSequence[]{MULTI_LEVEL_WILDCARD, SINGLE_LEVEL_WILDCARD})) {
                return;
            }
            boolean bl = multi = MqttTopic.countMatches(topicString, MULTI_LEVEL_WILDCARD) > 1 || topicString.contains(MULTI_LEVEL_WILDCARD) && !topicString.endsWith(MULTI_LEVEL_WILDCARD_PATTERN);
            if (multi) {
                throw new IllegalArgumentException("Invalid usage of multi-level wildcard in topic string: " + topicString);
            }
            MqttTopic.validateSingleLevelWildcard(topicString);
            return;
        }
        if (StringUtils.containsAny((CharSequence)topicString, (CharSequence)TOPIC_WILDCARDS)) {
            throw new IllegalArgumentException("The topic name MUST NOT contain any wildcard characters (#+)");
        }
    }

    public static int countMatches(CharSequence str, CharSequence sub) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{str, sub})) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = MqttTopic.indexOf(str, sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    private static int indexOf(CharSequence cs, CharSequence searchChar, int start) {
        return cs.toString().indexOf(searchChar.toString(), start);
    }

    public static boolean isMatched(String topicFilter, String topicName) throws IllegalArgumentException {
        int filterPos;
        int topicPos = 0;
        int topicLen = topicName.length();
        int filterLen = topicFilter.length();
        MqttTopic.validate(topicFilter, true);
        MqttTopic.validate(topicName, false);
        char multistage = '#';
        char single = '+';
        char segment = '/';
        if (topicFilter.equals(topicName)) {
            return true;
        }
        for (filterPos = 0; filterPos < filterLen && topicPos < topicLen; ++filterPos, ++topicPos) {
            if (topicFilter.charAt(filterPos) == multistage) {
                topicPos = topicLen;
                filterPos = filterLen;
                break;
            }
            if (topicName.charAt(topicPos) == segment && topicFilter.charAt(filterPos) != segment || topicFilter.charAt(filterPos) != single && topicFilter.charAt(filterPos) != multistage && topicFilter.charAt(filterPos) != topicName.charAt(topicPos)) break;
            if (topicFilter.charAt(filterPos) != single) continue;
            int nextpos = topicPos + 1;
            while (nextpos < topicLen && topicName.charAt(nextpos) != segment) {
                nextpos = ++topicPos + 1;
            }
        }
        if (topicPos == topicLen && filterPos == filterLen) {
            return true;
        }
        if (topicFilter.length() - filterPos > 0 && topicPos == topicLen) {
            if (topicName.charAt(topicPos - 1) == segment && topicFilter.charAt(filterPos) == multistage) {
                return true;
            }
            return topicFilter.length() - filterPos > 1 && topicFilter.startsWith(MULTI_LEVEL_WILDCARD_PATTERN, filterPos);
        }
        return false;
    }

    private static void validateSingleLevelWildcard(String topicString) {
        char singleLevelWildcardChar = SINGLE_LEVEL_WILDCARD.charAt(0);
        char topicLevelSeparatorChar = TOPIC_LEVEL_SEPARATOR.charAt(0);
        char[] chars = topicString.toCharArray();
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            boolean flag;
            char next;
            char prev = i - 1 >= 0 ? chars[i - 1] : (char)'\u0000';
            char c = next = i + 1 < length ? chars[i + 1] : (char)'\u0000';
            if (chars[i] != singleLevelWildcardChar) continue;
            boolean bl = flag = prev != topicLevelSeparatorChar && prev != '\u0000' || next != topicLevelSeparatorChar && next != '\u0000';
            if (!flag) continue;
            throw new IllegalArgumentException(String.format("Invalid usage of single-level wildcard in topic string '%s'!", topicString));
        }
    }
}

