/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.mqtt.client;

import cn.sinozg.applet.common.utils.SnowFlake;
import cn.sinozg.applet.mqtt.client.BaseMqttVertx;
import cn.sinozg.applet.mqtt.model.MqttConfigInfo;
import cn.sinozg.applet.mqtt.util.MqttTopic;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.mqtt.MqttClient;
import io.vertx.mqtt.MqttClientOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttVertxClient
extends BaseMqttVertx {
    private final String id;
    private MqttClient client;
    private static final Logger log = LoggerFactory.getLogger(MqttVertxClient.class);
    private final Map<String, String> TOPIC_MAP = new HashMap<String, String>(1024);

    public MqttVertxClient(MqttConfigInfo config) {
        super(config);
        this.id = SnowFlake.genId();
    }

    public void start() throws Exception {
        MqttClientOptions options = new MqttClientOptions();
        if (this.config.isSsl()) {
            options.setSsl(this.config.isSsl()).setPemKeyCertOptions(new PemKeyCertOptions().addKeyPath(this.config.getSslKey()).addCertPath(this.config.getSslCert()));
        }
        options.setClientId(this.config.getClientId());
        if (StringUtils.isNotBlank((CharSequence)this.config.getUserName())) {
            options.setUsername(this.config.getUserName());
            options.setPassword(this.config.getPassword());
        }
        options.setAutoKeepAlive(true);
        options.setReconnectAttempts(30);
        MqttClient client = MqttClient.create((Vertx)this.vertx, (MqttClientOptions)options);
        this.setClient(client);
        this.mqttConnection();
    }

    public void stop() {
        this.client.disconnect();
    }

    @Override
    protected boolean publishMessage(String topic, String subscribeTopic, Buffer payload) {
        AtomicBoolean flag = new AtomicBoolean(false);
        this.client.publish(topic, payload, MqttQoS.AT_MOST_ONCE, false, false, s -> {
            if (s.succeeded()) {
                if (StringUtils.isNotBlank((CharSequence)subscribeTopic)) {
                    this.subscribe(subscribeTopic, MqttQoS.AT_MOST_ONCE.value());
                }
                flag.set(true);
                log.info("\u53d1\u5e03\u6d88\u606f\u6210\u529f, {}\uff0c{}", s.result(), (Object)flag.get());
            } else {
                log.error("===>\u5ba2\u6237\u7aef\u53d1\u5e03\u6d88\u606f\u5931\u8d25: ", s.cause());
            }
        });
        return flag.get();
    }

    public void setClient(MqttClient client) {
        if (this.client != null && this.client != client) {
            try {
                this.client.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.client = client;
        client.closeHandler(nil -> log.debug("\u5173\u95edmqtt \u5ba2\u6237\u7aef [{}] closed", (Object)this.id)).publishHandler(msg -> {
            if (log.isDebugEnabled()) {
                log.debug("\u5ba2\u6237\u7aef\u63a5\u6536\u5230\u7684\u8ba2\u9605\u6d88\u606f topic [{}] with QoS [{}]", (Object)msg.topicName(), (Object)msg.qosLevel().value());
            }
            HashMap<String, Object> header = new HashMap<String, Object>(16);
            String topic = msg.topicName();
            header.put("topic", topic);
            this.messageService.onReceive(header, msg.payload());
        });
    }

    public void unsubscribe(String topics) {
        if (this.contains(topics)) {
            this.client.unsubscribe(topics, result -> {
                if (result.succeeded()) {
                    this.TOPIC_MAP.remove(topics);
                } else {
                    log.error("\u53d6\u6d88mqtt\u8ba2\u9605 topic {} \u5931\u8d25\uff01", (Object)topics, (Object)result.cause());
                }
            });
        }
    }

    public void subscribe(String topics, int qos) {
        if (!this.contains(topics)) {
            this.client.subscribe(topics, qos, result -> {
                if (!result.succeeded()) {
                    log.error("\u8ba2\u9605mqtt \u5931\u8d25 , {}", (Object)topics, (Object)result.cause());
                } else {
                    this.TOPIC_MAP.put(topics, topics);
                    log.info("\u8ba2\u9605mqtt \u6210\u529f {}, {}", (Object)topics, result.result());
                }
            });
        }
    }

    private boolean contains(String key) {
        if (MapUtils.isNotEmpty(this.TOPIC_MAP)) {
            for (Map.Entry<String, String> e : this.TOPIC_MAP.entrySet()) {
                if (!MqttTopic.isMatched(e.getKey(), key)) continue;
                return true;
            }
        }
        return false;
    }

    public void mqttConnection() {
        this.client.connect(this.config.getPort(), this.config.getIp(), r -> {
            if (!r.succeeded()) {
                log.error("\u94fe\u63a5mqtt [{}@{}:{}] \u5931\u8d25", new Object[]{this.config.getClientId(), this.config.getIp(), this.config.getPort(), r.cause()});
            } else {
                log.debug("\u94fe\u63a5mqtt [{}] \u6210\u529f", (Object)this.id);
                List<String> topics = this.config.getSubscribe();
                if (CollectionUtils.isNotEmpty(topics)) {
                    for (String topic : topics) {
                        log.info("\u521d\u59cb\u5316\u8ba2\u9605 topic {}", (Object)topic);
                        this.subscribe(topic, MqttQoS.AT_MOST_ONCE.value());
                    }
                }
            }
        }).exceptionHandler(e -> log.error("\u94fe\u63a5mqtt \u5f02\u5e38 : ", e.getCause()));
    }
}

