/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.mqtt.component;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.SnowFlake;
import cn.sinozg.applet.mqtt.client.BaseMqttVertx;
import cn.sinozg.applet.mqtt.client.MqttVertxClient;
import cn.sinozg.applet.mqtt.factory.MqttSubscribeFactory;
import cn.sinozg.applet.mqtt.model.MqttConfigInfo;
import cn.sinozg.applet.mqtt.model.MqttMessageInfo;
import cn.sinozg.applet.mqtt.model.MqttServerConfig;
import cn.sinozg.applet.mqtt.service.SubscribeService;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttProtocolComponent {
    private Vertx vertx;
    private BaseMqttVertx mqttVertx;
    private CountDownLatch countDownLatch;
    private String deployedId;
    private SubscribeService service;
    private static final Logger log = LoggerFactory.getLogger(MqttProtocolComponent.class);

    public void create(MqttServerConfig mqtt, SubscribeService service) {
        this.service = service;
        MqttConfigInfo config = new MqttConfigInfo();
        config.setClientId(SnowFlake.genId());
        config.setIp(mqtt.getIp());
        config.setPort(mqtt.getPort());
        config.setUserName(mqtt.getUsername());
        config.setPassword(mqtt.getPassword());
        List<String> subscribe = MqttSubscribeFactory.topics();
        if (CollectionUtils.isNotEmpty(subscribe)) {
            config.setSubscribe(subscribe);
        }
        this.vertx = Vertx.vertx();
        this.mqttVertx = new MqttVertxClient(config);
    }

    public void start() {
        this.mqttVertx.setMessageService(this.service);
        this.countDownLatch = new CountDownLatch(1);
        Future future = this.vertx.deployVerticle((Verticle)this.mqttVertx);
        future.onSuccess(id -> {
            this.deployedId = id;
            this.countDownLatch.countDown();
        });
        future.onFailure(e -> {
            this.countDownLatch.countDown();
            log.error("\u542f\u52a8mqtt \u7ec4\u4ef6\u5931\u8d25\uff01");
        });
        try {
            future.succeeded();
            this.countDownLatch.await();
        }
        catch (Exception e2) {
            log.error("\u542f\u52a8mqtt \u5931\u8d25\uff01", e2.getCause());
        }
    }

    public void stop() {
        log.info("stop report");
        try {
            this.mqttVertx.stop();
        }
        catch (Exception e) {
            throw new CavException("BIZ000100057", e);
        }
        Future future = this.vertx.undeploy(this.deployedId);
        future.onSuccess(unused -> log.info("stop report component success"));
    }

    public void destory() {
    }

    public boolean send(MqttMessageInfo message) {
        String topic = message.getTopic();
        Object payload = message.getPayload();
        if (log.isDebugEnabled()) {
            log.debug("publish topic:{}, payload:{}", (Object)topic, payload);
        }
        return this.mqttVertx.publish(topic, message.getSubscribeTopic(), payload);
    }
}

