/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.mqtt.component;

import cn.sinozg.applet.mqtt.exception.RetrySendException;
import cn.sinozg.applet.mqtt.service.MqttSendService;
import cn.sinozg.applet.mqtt.service.SendRetryService;
import jakarta.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Recover;
import org.springframework.retry.annotation.Retryable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class SendWithRetry {
    @Resource
    private MqttSendService mqttSendService;
    private static final Logger log = LoggerFactory.getLogger(SendWithRetry.class);

    @Async
    @Retryable(retryFor={RetrySendException.class}, maxAttempts=5, backoff=@Backoff(delay=5000L))
    public void retrySend(String optId, String topic, Object issueOrder, SendRetryService retryService) {
        this.mqttSendService.send(topic, issueOrder);
        if (retryService.fail(optId)) {
            throw new RetrySendException();
        }
    }

    @Recover
    public void recover(Exception e, String optId, String topic, Object issueOrder, SendRetryService retryService) {
        log.info("\u53d1\u9001\u6307\u4ee4\u5931\u8d25 topic {} .\u65e5\u5fd7id{}\uff0c\u6307\u4ee4\u4e3a\uff1a{}", new Object[]{topic, optId, issueOrder});
        retryService.recover(optId);
    }
}

