/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.mqtt.service.impl;

import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.mqtt.factory.MqttSubscribeFactory;
import cn.sinozg.applet.mqtt.service.SubscribeHandleService;
import cn.sinozg.applet.mqtt.service.SubscribeService;
import io.vertx.core.buffer.Buffer;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class MqttSubscribeServiceImpl
implements SubscribeService {
    private static final Logger log = LoggerFactory.getLogger(MqttSubscribeServiceImpl.class);

    @Override
    @Async
    public void onReceive(Map<String, Object> headers, Buffer payload) {
        String topic = MapUtils.getString(headers, (Object)"topic");
        SubscribeHandleService service = MqttSubscribeFactory.handleService(topic);
        if (service == null) {
            log.error("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8ba2\u9605\u4e3b\u9898\u5b9e\u73b0\uff1a{}", (Object)topic);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u63a5\u53d7\u5230\u7684\u6307\u4ee4 topic\u4e3a{}, \u6d88\u606f\u4e3a:{}", (Object)JsonUtil.toJson(headers), (Object)payload);
        }
        service.handlePayload(topic, payload);
    }
}

