/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.mqtt.service.impl;

import cn.sinozg.applet.mq.mq.MqProducer;
import cn.sinozg.applet.mqtt.joint.MqttAutoBaseTopic;
import cn.sinozg.applet.mqtt.model.MqttSubscribeMq;
import cn.sinozg.applet.mqtt.service.SubscribeHandleService;
import io.vertx.core.buffer.Buffer;
import jakarta.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;

public abstract class SubscribeHandleBaseService
implements SubscribeHandleService {
    private static final Logger log = LoggerFactory.getLogger(SubscribeHandleBaseService.class);
    @Resource(name="mqttMqProducer")
    private MqProducer<MqttSubscribeMq> mqttMqProducer;

    @Override
    @Async
    public void handlePayload(String topic, Buffer message) {
        try {
            MqttAutoBaseTopic mt = this.topic();
            MqttSubscribeMq mq = this.decode(topic, message);
            if (mq != null && mt.mqTopic() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("\u8ba2\u9605\u6d88\u606f\u8f6c\u53d1 mqtt topic:{}, mq topic\uff1a{}, \u6307\u4ee4\u4e3a\uff1a{}", new Object[]{topic, mt.mqttTopic(), mq.getPayload()});
                }
                this.mqttMqProducer.publish(mt.mqTopic(), (Object)mq);
            }
        }
        catch (Exception e) {
            log.error("\u8ba2\u9605\u5904\u7406\u6d88\u606f\u5f02\u5e38\uff01");
        }
    }
}

