/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.mqtt.subscribe;

import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.SpringUtil;
import cn.sinozg.applet.mq.handle.ConsumerAutoHandler;
import cn.sinozg.applet.mq.joint.BaseTopicType;
import cn.sinozg.applet.mq.mq.MqConsumer;
import cn.sinozg.applet.mqtt.model.MqttSubscribeMq;
import cn.sinozg.applet.mqtt.service.InitializationMqttService;
import cn.sinozg.applet.mqtt.subscribe.AbstractEventStrategy;
import cn.sinozg.applet.mqtt.subscribe.EventMqttDataParams;
import cn.sinozg.applet.mqtt.subscribe.MqttBaseEventType;
import cn.sinozg.applet.mqtt.subscribe.TopicFactory;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MqttSubscribeConsumer
implements ConsumerAutoHandler<MqttSubscribeMq> {
    @Resource(name="mqttMqConsumer")
    private MqConsumer<MqttSubscribeMq> mqttMqConsumer;
    @Resource
    private InitializationMqttService initializationMqttService;
    private static final Map<MqttBaseEventType, AbstractEventStrategy<?>> STRATEGY_MAP = new HashMap(16);
    private static final Logger log = LoggerFactory.getLogger(MqttSubscribeConsumer.class);

    public MqConsumer<MqttSubscribeMq> consumer() {
        return this.mqttMqConsumer;
    }

    public BaseTopicType type() {
        return TopicFactory.getInstance().mqTopic();
    }

    public void handler(MqttSubscribeMq msg) {
        String payload = msg.getPayload();
        try {
            EventMqttDataParams<?> params = this.initializationMqttService.convertParams(msg);
            if (payload == null || params == null || params.getType() == null) {
                log.error("\u8fd4\u56demqtt\u5904\u7406\u6570\u636e\u9519\u8bef\uff01");
                return;
            }
            AbstractEventStrategy strategy = (AbstractEventStrategy)SpringUtil.beanOfType((Object)params.getType(), AbstractEventStrategy.class, STRATEGY_MAP, AbstractEventStrategy::type);
            if (strategy == null) {
                log.error("\u672a\u77e5\u7684\u6570\u636e\u7c7b\u578b\uff1a{}", (Object)payload);
                return;
            }
            if (StringUtils.isBlank((CharSequence)params.getPayload())) {
                params.setPayload(payload);
            }
            params.setTopic(msg.getTopic());
            strategy.eventHandle((EventMqttDataParams)PojoUtil.cast(params));
        }
        catch (Exception e) {
            log.error("HandMqttSubscribeConsumer \u6307\u4ee4{} ERROR  {}", (Object)payload, (Object)e.getMessage());
        }
    }
}

