package cn.sinozg.applet.biz.opt.vo.request;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
* 操作、数据日志记录表 分页请求参数
* @Description
* @Copyright Copyright (c) 2024
* @author xieyubin
* @since 2024-02-28 18:03:49
*/
@Data
@Schema(name = "OptLogDataPageRequest", description = "操作、数据日志记录 分页请求参数")
public class OptLogDataPageRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 模块标题 */
    @Schema(description = "模块标题")
    private String title;

    /** 模块 */
    @Schema(description = "模块")
    private String moduleName;

    /** 业务类型;00其它 01新增 02修改 03删除 */
    @Schema(description = "业务类型;00其它 01新增 02修改 03删除")
    private String businessType;

    /** 操作类别;00其它 01后台用户 02手机端用户 */
    @Schema(description = "操作类别;00其它 01后台用户 02手机端用户")
    private String optType;

    @Schema(description = "开始时间 yyyy-MM-dd")
    private String beginTime;

    @Schema(description = "结束时间 yyyy-MM-dd")
    private String endTime;
}
