package cn.sinozg.applet.opt.module;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


/**
 * 当前请求的所有修改记录对象
 * 跟随整个接口生命周期
 * @Description
 * @Copyright Copyright (c) 2024
 * @author xieyubin
 * @since 2024-02-27 21:08:19
 */
@Data
public class OptLogCycleInfo implements Serializable {

    /**
     * 线程名称
     */
    @Schema(description = "线程名称")
    private String threadName;

    @Schema(description = "当次修改会话的唯一标识")
    private String traceId;

    /**
     * 修改记录 基本信息
     */
    @Schema(description = "修改记录 基本信息")
    private OptLogMain main;

    /**
     * 修改记录,当前mapper方法信息 对应的一条一条的记录
     * 一对多 一对一等等
     */
    private List<OptLogTableInfo> items = new ArrayList<>();
}
