/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.aspectj;

import cn.sinozg.applet.common.holder.MdcContextHolder;
import cn.sinozg.applet.common.service.FrameworkAuthService;
import cn.sinozg.applet.common.utils.OsUtil;
import cn.sinozg.applet.common.utils.SnowFlake;
import cn.sinozg.applet.common.utils.UserUtil;
import cn.sinozg.applet.common.utils.WebUtil;
import cn.sinozg.applet.opt.cache.OptLogCache;
import cn.sinozg.applet.opt.cache.OptLogThreadCache;
import cn.sinozg.applet.opt.config.OptLogProperties;
import cn.sinozg.applet.opt.module.OptLogCycleInfo;
import cn.sinozg.applet.opt.module.OptLogMain;
import cn.sinozg.applet.opt.module.OptLogTableInfo;
import cn.sinozg.applet.opt.service.OptLogService;
import cn.sinozg.applet.opt.util.OptUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class OptLogDataAspect {
    private static final Logger log = LoggerFactory.getLogger(OptLogDataAspect.class);
    private final OptLogProperties recordProperties;
    private final OptLogService optLogService;
    private final FrameworkAuthService authService;
    private static final String RESULT = "result";
    private static final String EXCEPTION = "exception";
    private static final String POINTCUT = "@annotation(cn.sinozg.applet.common.annotation.OptLog)";

    public OptLogDataAspect(OptLogProperties properties, OptLogService optLogService, FrameworkAuthService authService) {
        this.recordProperties = properties;
        this.optLogService = optLogService;
        this.authService = authService;
    }

    @Before(value="@annotation(cn.sinozg.applet.common.annotation.OptLog)")
    public void doBefore(JoinPoint joinPoint) {
        try {
            OptLogCycleInfo result = new OptLogCycleInfo();
            String traceId = MdcContextHolder.get();
            if (StringUtils.isBlank((CharSequence)traceId)) {
                traceId = SnowFlake.genId();
            }
            result.setTraceId(traceId);
            result.setThreadName(Thread.currentThread().getName());
            HttpServletRequest request = WebUtil.request();
            Signature signature = joinPoint.getSignature();
            MethodSignature methodSignature = (MethodSignature)signature;
            Method method = methodSignature.getMethod();
            Class<?> controller = joinPoint.getTarget().getClass();
            OptLogMain main = OptLogCache.apiBaseInfo(controller, method, this.recordProperties.isDataLog(), request);
            if (main.getTie() != null) {
                result.setItems(new ArrayList<OptLogTableInfo>());
            }
            if (main.isSaveParams()) {
                String params = OptUtil.requestParamsToJson(request.getMethod(), joinPoint);
                main.setJsonParam(params);
            }
            String ip = OsUtil.getIpAddr((HttpServletRequest)request);
            main.setOptIp(ip);
            result.setMain(main);
            OptLogThreadCache.set(result);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8bf7\u6c42\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterReturning(value="@annotation(cn.sinozg.applet.common.annotation.OptLog)", returning="result")
    public void doAfterReturning(JoinPoint joinPoint, Object result) {
        try {
            OptLogCycleInfo cycleInfo = OptLogThreadCache.get();
            String token = this.authService.token();
            this.optLogService.saveLog(token, UserUtil.user(), cycleInfo, null, result);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u65e5\u5fd7\u9519\u8bef\uff01", (Throwable)e);
        }
        finally {
            OptLogThreadCache.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterThrowing(value="@annotation(cn.sinozg.applet.common.annotation.OptLog)", throwing="exception")
    protected void doAfterThrowing(Exception exception) {
        try {
            OptLogCycleInfo cycleInfo = OptLogThreadCache.get();
            String token = this.authService.token();
            this.optLogService.saveLog(token, UserUtil.user(), cycleInfo, exception, null);
        }
        catch (Exception e) {
            log.error("\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38\uff01", (Throwable)e);
        }
        finally {
            OptLogThreadCache.remove();
        }
    }
}

