package cn.sinozg.applet.biz.opt.service.impl;

import cn.sinozg.applet.biz.opt.entity.OptLogData;
import cn.sinozg.applet.biz.opt.entity.OptLogTable;
import cn.sinozg.applet.biz.opt.entity.OptLogText;
import cn.sinozg.applet.biz.opt.mapper.OptLogDataMapper;
import cn.sinozg.applet.biz.opt.service.OptLogDataService;
import cn.sinozg.applet.biz.opt.service.OptLogTableService;
import cn.sinozg.applet.biz.opt.service.OptLogTextService;
import cn.sinozg.applet.biz.opt.vo.request.OptLogClearRequest;
import cn.sinozg.applet.biz.opt.vo.request.OptLogDataByBizIdPageRequest;
import cn.sinozg.applet.biz.opt.vo.request.OptLogDataPageRequest;
import cn.sinozg.applet.biz.opt.vo.response.OptLogDataByBizIdPageResponse;
import cn.sinozg.applet.biz.opt.vo.response.OptLogDataPageResponse;
import cn.sinozg.applet.common.core.base.BasePageResponse;
import cn.sinozg.applet.common.core.base.PagingRequest;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.PageUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.opt.module.OptLogDiffTable;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.function.Function;

/**
* 操作、数据日志记录 服务实现类
* @Description
* @Copyright Copyright (c) 2024
* @author xieyubin
* @since 2024-02-28 18:03:49
*/
@Service
public class OptLogDataServiceImpl extends ServiceImpl<OptLogDataMapper, OptLogData> implements OptLogDataService {

    @Resource
    private OptLogDataMapper mapper;

    @Resource
    private OptLogTextService textService;

    @Resource
    private OptLogTableService tableService;

    @Override
    public OptLogDataByBizIdPageResponse logDataDetailById(String id) {
        OptLogDataByBizIdPageRequest params = new OptLogDataByBizIdPageRequest();
        params.setId(id);
        OptLogDataByBizIdPageResponse response = mapper.logDataDetailById(params);
        this.convert(response);
        return response;
    }

    @Override
    public BasePageResponse<List<OptLogDataByBizIdPageResponse>> logDataDetailByBizId(PagingRequest page, OptLogDataByBizIdPageRequest params){
        PageUtil<OptLogDataByBizIdPageResponse, OptLogDataByBizIdPageRequest> pu = (p, q) -> mapper.logDataDetailByBizId(p, q);
        BasePageResponse<List<OptLogDataByBizIdPageResponse>> response = pu.page(page, params);
        if (CollectionUtils.isNotEmpty(response.getData())) {
            response.getData().forEach(this::convert);
        }
        return response;
    }

    @Override
    @Transactional(rollbackFor = Throwable.class)
    public void clear(OptLogClearRequest params) {
        List<String> logIdList = null;
        boolean clearAll = StringUtils.isAllBlank(params.getId(), params.getBizId(), params.getBeforeTime()) && params.isClearAll();
        // 根据biz删除
        if (StringUtils.isNotBlank(params.getBizId())) {
            logIdList = mapper.idListInfoByBizId(params);
        } else if (clearAll || !StringUtils.isAllBlank(params.getBeforeTime(), params.getId())) {
            logIdList = mapper.idListInfo(params);
        }
        if (CollectionUtils.isEmpty(logIdList)) {
            return;
        }
        // 批量删除数据
        List<List<String>> list = PojoUtil.batchList(logIdList, Function.identity());
        for (List<String> ids : list) {
            this.removeBatchByIds(ids);
            textService.remove(new LambdaQueryWrapper<OptLogText>().in(OptLogText::getLogId, ids));
            tableService.remove(new LambdaQueryWrapper<OptLogTable>().in(OptLogTable::getLogId, ids));
        }
    }

    @Override
    public BasePageResponse<List<OptLogDataPageResponse>> pageInfo(PagingRequest page, OptLogDataPageRequest params) {
        PageUtil<OptLogDataPageResponse, OptLogDataPageRequest> pu = (p, q) -> mapper.pageInfo(p, q);
        return pu.page(page, params);
    }

    /**
     * 数据转化
     * @param p 参数
     */
    private void convert(OptLogDataByBizIdPageResponse p){
        if (p != null && StringUtils.isNotBlank(p.getJsonDiff())) {
            p.setDiff(JsonUtil.toPojo(p.getJsonDiff(), OptLogDiffTable.class));
        }
    }
}
