package cn.sinozg.applet.opt.config;

import cn.sinozg.applet.common.aspectj.OptLogDataAspect;
import cn.sinozg.applet.common.interceptor.OptLogMybatisInterceptor;
import cn.sinozg.applet.common.service.FrameworkAuthService;
import cn.sinozg.applet.opt.mark.OptLogMarker;
import cn.sinozg.applet.opt.service.OptLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-15 18:42
 */
@Slf4j
@Configuration
@ConditionalOnBean(OptLogMarker.class)
public class OptLogAutoConfiguration {
    @Bean
    public OptLogDataAspect optLogDataAspect(OptLogProperties optLogProperties, OptLogService optLogService, FrameworkAuthService authService){
        log.info("启动 日志监控。。。");
        return new OptLogDataAspect(optLogProperties, optLogService, authService);
    }

    @Bean
    @ConditionalOnProperty(name = OptLogProperties.UPDATE_RECORD_PREFIX + ".data-log", havingValue = "true")
    public OptLogMybatisInterceptor updateRecordMybatisInterceptor (OptLogProperties optLogProperties){
        log.info("启动 日志数据监控。。。*******");
        return new OptLogMybatisInterceptor(optLogProperties);
    }
}
