/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.opt.cache;

import cn.sinozg.applet.common.annotation.OptIgnore;
import cn.sinozg.applet.common.annotation.OptLog;
import cn.sinozg.applet.common.annotation.OptLogField;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.RedisUtil;
import cn.sinozg.applet.opt.config.OptLogProperties;
import cn.sinozg.applet.opt.constant.OptLogConstant;
import cn.sinozg.applet.opt.module.OptLogMain;
import cn.sinozg.applet.opt.module.OptMapperColumn;
import cn.sinozg.applet.opt.module.OptMapperTable;
import cn.sinozg.applet.opt.module.OptTieRelation;
import cn.sinozg.applet.opt.util.OptUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptLogCache {
    private static final Logger log = LoggerFactory.getLogger(OptLogCache.class);
    private static final Map<Class<?>, OptTieRelation<?>> TIE_MAP = new ConcurrentHashMap();

    public static boolean clearApiBaseInfo() {
        return RedisUtil.deleteKeys((String)"jby:biz:opt_log:");
    }

    public static OptLogMain apiBaseInfo(Class<?> controller, Method method, boolean isDataLog, HttpServletRequest request) {
        String className = controller.getName();
        String methodName = method.getName();
        String key = className + "." + methodName;
        String redisKey = String.format("jby:biz:opt_log:api:%s", key);
        OptLogMain main = (OptLogMain)RedisUtil.getCacheObject((String)redisKey);
        if (main != null) {
            return main;
        }
        main = new OptLogMain();
        String title = null;
        String moduleName = null;
        OptLog optLog = method.getAnnotation(OptLog.class);
        if (StringUtils.isNotBlank((CharSequence)optLog.module())) {
            moduleName = optLog.module();
        } else {
            Tag tag = controller.getAnnotation(Tag.class);
            if (tag != null) {
                moduleName = tag.description();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)optLog.title())) {
            title = optLog.title();
        } else {
            Operation operation = method.getAnnotation(Operation.class);
            if (operation != null) {
                title = operation.summary();
            }
        }
        Class<?> tie = null;
        String requestMethod = request.getMethod();
        if (isDataLog && optLog.dataLog()) {
            tie = optLog.tie();
            if (tie == Void.class) {
                tie = OptUtil.firstMethodParams(method, requestMethod);
            }
            if (tie == null) {
                log.error("\u4e0d\u8bb0\u5f55\u4fee\u6539\u65e5\u5fd7\u8be6\u60c5\uff0c\u8bf7\u8bbe\u7f6e\u65e5\u5fd7\u53c2\u6570\u7684\u5173\u8054\u5173\u7cfb\uff01{}.{}", (Object)className, (Object)methodName);
            }
        }
        main.setModuleName(moduleName);
        main.setTitle(title);
        main.setMethodName(key + "()");
        main.setBusinessType(optLog.bizType().getCode());
        main.setOptType(optLog.optType().getCode());
        String url = request.getRequestURI();
        main.setOptUrl(url);
        main.setRequestMethod(requestMethod);
        if (optLog.saveParams()) {
            main.setSaveParams(true);
        }
        main.setTie(tie);
        RedisUtil.setCacheObject((String)redisKey, (Object)main);
        return main;
    }

    public static OptMapperTable getCacheTableInfo(Class<?> clazz, OptLogProperties properties) {
        String redisKey = String.format("jby:biz:opt_log:table:%s", clazz.getName());
        OptMapperTable tableInfo = (OptMapperTable)RedisUtil.getCacheObject((String)redisKey);
        if (tableInfo != null) {
            return tableInfo;
        }
        tableInfo = OptLogCache.generatorTableInfo(clazz, properties);
        RedisUtil.setCacheObject((String)redisKey, (Object)tableInfo);
        return tableInfo;
    }

    public static <T> OptTieRelation<T> optTie(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        if (TIE_MAP.containsKey(clazz)) {
            return (OptTieRelation)PojoUtil.cast(TIE_MAP.get(clazz));
        }
        OptTieRelation<T> relation = OptUtil.optTie(clazz);
        TIE_MAP.put(clazz, relation);
        return relation;
    }

    public static boolean ignoreMethod(Class<?> clazz, String methodName) {
        String redisKey = String.format("jby:biz:opt_log:ignore:%s", clazz.getName());
        ArrayList<String> list = (ArrayList<String>)RedisUtil.getCacheObject((String)redisKey);
        if (list == null) {
            Object[] methods = clazz.getDeclaredMethods();
            list = new ArrayList<String>();
            if (ArrayUtils.isNotEmpty((Object[])methods)) {
                for (Object method : methods) {
                    OptIgnore optIgnore = ((Method)method).getAnnotation(OptIgnore.class);
                    if (optIgnore == null) continue;
                    list.add(((Method)method).getName());
                }
            }
            RedisUtil.setCacheObject((String)redisKey, list);
        }
        return CollectionUtils.containsAny(list, (Object[])new String[]{methodName});
    }

    private static OptMapperTable generatorTableInfo(Class<?> clazz, OptLogProperties properties) {
        OptMapperTable tableInfo = OptLogCache.tableBaseInfo(clazz, properties);
        if (!tableInfo.isRecord()) {
            return tableInfo;
        }
        List fields = PojoUtil.allField(clazz);
        if (CollectionUtils.isEmpty((Collection)fields)) {
            return tableInfo;
        }
        ArrayList<OptMapperColumn> columns = new ArrayList<OptMapperColumn>();
        int index = 0;
        for (Field field : fields) {
            OptMapperColumn column = OptLogCache.column(tableInfo, field, properties);
            if (column == null) continue;
            column.setSort(Math.min(index, column.getSort()));
            columns.add(column);
            ++index;
        }
        if (CollectionUtils.isNotEmpty(columns)) {
            columns.sort(Comparator.comparing(OptMapperColumn::getSort));
            ConcurrentSkipListMap<String, OptMapperColumn> propertyMap = new ConcurrentSkipListMap<String, OptMapperColumn>();
            for (OptMapperColumn column : columns) {
                propertyMap.put(column.getPropertyName(), column);
            }
            tableInfo.setPropertyMap(propertyMap);
        } else {
            tableInfo.setRecord(false);
        }
        return tableInfo;
    }

    private static OptMapperColumn column(OptMapperTable table, Field field, OptLogProperties properties) {
        TableField tableField;
        field.setAccessible(true);
        String propertyName = field.getName();
        if (OptLogConstant.DEFAULT_EXCLUDE_FIELDS.contains(propertyName)) {
            return null;
        }
        String columnName = null;
        String columnDesc = null;
        OptMapperColumn column = new OptMapperColumn();
        column.setPropertyName(propertyName);
        column.setTypeClass(field.getType());
        TableId tableId = field.getAnnotation(TableId.class);
        if (tableId != null) {
            columnName = tableId.value();
            table.setIdColumnName(tableId.value());
            table.setIdPropertyName(propertyName);
        }
        int sort = Integer.MAX_VALUE;
        OptLogField recordField = field.getAnnotation(OptLogField.class);
        if (recordField != null && recordField.ignore()) {
            return null;
        }
        Schema schema = field.getAnnotation(Schema.class);
        if (schema != null) {
            columnDesc = schema.description();
        }
        if (recordField != null) {
            columnDesc = recordField.desc();
            sort = recordField.sort();
        }
        if (StringUtils.isBlank((CharSequence)columnName) && (tableField = field.getAnnotation(TableField.class)) != null) {
            columnName = tableField.value();
        }
        if (StringUtils.isBlank((CharSequence)columnDesc)) {
            columnDesc = columnName;
        }
        column.setColumnName(columnName);
        column.setColumnDesc(columnDesc);
        if (OptUtil.exclude(columnName, properties.getIncludeColumns(), properties.getExcludeColumns())) {
            return null;
        }
        column.setSort(sort);
        return column;
    }

    private static OptMapperTable tableBaseInfo(Class<?> clazz, OptLogProperties properties) {
        OptMapperTable tableInfo = new OptMapperTable();
        tableInfo.setType(clazz);
        String entityName = clazz.getSimpleName();
        tableInfo.setEntityName(entityName);
        Schema classSchema = clazz.getAnnotation(Schema.class);
        TableName tn = clazz.getAnnotation(TableName.class);
        String tableName = null;
        String tableDesc = null;
        if (classSchema != null) {
            tableDesc = classSchema.description();
        }
        if (tn != null) {
            tableName = tn.value();
        }
        tableInfo.setTableName(tableName);
        tableInfo.setTableDesc(tableDesc);
        assert (tableName != null);
        if (CollectionUtils.containsAny(OptLogConstant.DEFAULT_EXCLUDE_TABLE, (Object[])new String[]{tableName.toLowerCase()}) || OptUtil.exclude(tableName, properties.getIncludeTables(), properties.getExcludeTables())) {
            tableInfo.setRecord(false);
            if (CollectionUtils.containsAny(OptLogConstant.DEFAULT_EXCLUDE_TABLE, (Object[])new String[]{tableName.toLowerCase()})) {
                tableInfo.setLogTable(true);
            }
        }
        return tableInfo;
    }
}

