package cn.sinozg.applet.biz.opt.vo.request;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
* 操作、数据日志记录表 分页请求参数
* @Description
* @Copyright Copyright (c) 2024
* @author xieyubin
* @since 2024-02-28 18:03:49
*/
@Data
@Schema(name = "OptLogDataByBizIdPageRequest", description = "操作、数据日志记录 分页请求参数")
public class OptLogDataByBizIdPageRequest implements Serializable {

    private static final long serialVersionUID = 1L;
    @Schema(description = "日志id")
    private String id;

    /** 业务id */
    @Schema(description = "业务id")
    @NotBlank(message = "业务id不能为空！")
    private String bizId;

    @Schema(description = "开始时间 yyyy-MM-dd")
    private String beginTime;

    @Schema(description = "结束时间 yyyy-MM-dd")
    private String endTime;
}
