package cn.sinozg.applet.biz.opt.entity;

import cn.sinozg.applet.common.core.base.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
* 操作、数据日志记录表
* @Description
* @Copyright Copyright (c) 2024
* @author xieyubin
* @since 2024-02-28 18:03:49
*/
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("sys_opt_log_data")
@Schema(name = "OptLogData", description = "操作、数据日志记录")
public class OptLogData extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /** 日志主键 */
    @Schema(description = "日志主键")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;


    /** 跟踪id */
    @Schema(description = "跟踪id")
    @TableField("trace_id")
    private String traceId;


    /** 模块标题 */
    @Schema(description = "模块标题")
    @TableField("title")
    private String title;


    /** 模块 */
    @Schema(description = "模块")
    @TableField("module_name")
    private String moduleName;


    /** 方法名称 */
    @Schema(description = "方法名称")
    @TableField("method_name")
    private String methodName;


    /** 业务类型;00其它 01新增 02修改 03删除 */
    @Schema(description = "业务类型;00其它 01新增 02修改 03删除")
    @TableField("business_type")
    private String businessType;


    /** 请求方式 */
    @Schema(description = "请求方式")
    @TableField("request_method")
    private String requestMethod;


    /** 操作类别;00其它 01后台用户 02手机端用户 */
    @Schema(description = "操作类别;00其它 01后台用户 02手机端用户")
    @TableField("opt_type")
    private String optType;


    /** 操作人员 */
    @Schema(description = "操作人员")
    @TableField("opt_name")
    private String optName;


    /** 部门名称 */
    @Schema(description = "部门名称")
    @TableField("dept_name")
    private String deptName;


    /** 请求URL */
    @Schema(description = "请求URL")
    @TableField("opt_url")
    private String optUrl;


    /** 主机地址 */
    @Schema(description = "主机地址")
    @TableField("opt_ip")
    private String optIp;


    /** 操作地点 */
    @Schema(description = "操作地点")
    @TableField("opt_location")
    private String optLocation;


    /** 操作状态;00正常 01异常 */
    @Schema(description = "操作状态;00正常 01异常")
    @TableField("data_status")
    private String dataStatus;


    /** 租户id */
    @Schema(description = "租户id")
    @TableField(value = "tenant_id", updateStrategy = FieldStrategy.NEVER)
    private String tenantId;

}
