/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.interceptor;

import cn.sinozg.applet.common.annotation.OptIgnore;
import cn.sinozg.applet.common.core.base.BaseEntity;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.opt.cache.OptLogCache;
import cn.sinozg.applet.opt.cache.OptLogThreadCache;
import cn.sinozg.applet.opt.config.OptLogProperties;
import cn.sinozg.applet.opt.enums.ModeEnum;
import cn.sinozg.applet.opt.module.OptLogCycleInfo;
import cn.sinozg.applet.opt.module.OptLogTableDetail;
import cn.sinozg.applet.opt.module.OptLogTableInfo;
import cn.sinozg.applet.opt.module.OptMapperColumn;
import cn.sinozg.applet.opt.module.OptMapperTable;
import cn.sinozg.applet.opt.module.OptTieRecord;
import cn.sinozg.applet.opt.module.OptTieRelation;
import cn.sinozg.applet.opt.util.OptUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.override.MybatisMapperProxy;
import com.baomidou.mybatisplus.core.toolkit.MybatisUtils;
import com.baomidou.mybatisplus.core.toolkit.TableNameParser;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="batch", args={Statement.class}), @Signature(type=StatementHandler.class, method="update", args={Statement.class})})
public class OptLogMybatisInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OptLogMybatisInterceptor.class);
    private final OptLogProperties properties;
    private static final String PLACEHOLDER = "\\?";

    public OptLogMybatisInterceptor(OptLogProperties properties) {
        this.properties = properties;
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        this.interceptionChain(invocation);
        return invocation.proceed();
    }

    private void interceptionChain(Invocation invocation) {
        if (OptLogThreadCache.empty()) {
            return;
        }
        try {
            StatementHandler statementHandler = (StatementHandler)this.getTarget(invocation.getTarget());
            MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
            MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
            SqlCommandType type = mappedStatement.getSqlCommandType();
            if (SqlCommandType.UPDATE != type && SqlCommandType.DELETE != type && SqlCommandType.INSERT != type) {
                return;
            }
            String methodId = mappedStatement.getId();
            if (this.isIgnoreMethod(methodId)) {
                return;
            }
            BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
            Pair<TableInfo, OptMapperTable> tablePair = this.entityTable(boundSql.getSql());
            if (tablePair == null) {
                return;
            }
            List parameterMappings = boundSql.getParameterMappings();
            if (parameterMappings == null) {
                log.warn("\u672a\u53d1\u73b0\u66f4\u65b0\u7684\u5b57\u6bb5");
                return;
            }
            this.handleDataLog(methodId, boundSql, (OptMapperTable)tablePair.getRight(), type, (TableInfo)tablePair.getLeft(), mappedStatement.getConfiguration());
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
        }
    }

    private void handleDataLog(String methodId, BoundSql boundSql, OptMapperTable mapperTable, SqlCommandType type, TableInfo tableInfo, Configuration configuration) {
        List<OptLogTableInfo> tbs;
        ModeEnum modeEnum;
        Map<Class<?>, OptTieRecord> recordMap;
        OptTieRecord record;
        OptLogTableDetail detail = new OptLogTableDetail();
        detail.setTraceId(OptLogThreadCache.getTraceId());
        detail.setMethodId(methodId);
        detail.setTableName(mapperTable.getTableName());
        detail.setTableDesc(mapperTable.getTableDesc());
        detail.setClazz(mapperTable.getType());
        OptLogCycleInfo cycleInfo = OptLogThreadCache.get();
        Class<?> tie = cycleInfo.getMain().getTie();
        OptTieRelation<?> relation = OptLogCache.optTie(tie);
        if (relation != null && (record = (recordMap = relation.getKeyMap()).get(mapperTable.getType())) != null) {
            detail.setIdName(record.getIdName());
            detail.setForeignIdName(record.getForeignIdName());
        }
        Map<String, Map<String, Object>> oldValues = null;
        if (type != SqlCommandType.INSERT) {
            oldValues = this.oldValuesByDb(configuration, boundSql, mapperTable, tableInfo, detail.getForeignIdName());
        }
        List<Map<String, Object>> newValues = null;
        if (type != SqlCommandType.DELETE) {
            Object paramObject = this.sqlParams(boundSql);
            if (paramObject == null) {
                return;
            }
            newValues = this.newValueMap(paramObject, mapperTable, boundSql.getParameterMappings());
        }
        if ((modeEnum = this.modeEnum(type, newValues, oldValues)) != null && CollectionUtils.isNotEmpty(tbs = OptUtil.compare(newValues, oldValues, mapperTable.getPropertyMap(), detail, modeEnum))) {
            OptLogThreadCache.adds(tbs);
        }
    }

    private ModeEnum modeEnum(SqlCommandType type, List<Map<String, Object>> newValues, Map<String, Map<String, Object>> oldValues) {
        ModeEnum mode = null;
        if (SqlCommandType.UPDATE == type && CollectionUtils.isNotEmpty(newValues) && MapUtils.isNotEmpty(oldValues)) {
            mode = ModeEnum.UPDATE;
        } else if (SqlCommandType.INSERT == type && CollectionUtils.isNotEmpty(newValues) && MapUtils.isEmpty(oldValues)) {
            mode = ModeEnum.ADD;
        } else if (SqlCommandType.DELETE == type && CollectionUtils.isEmpty(newValues) && MapUtils.isNotEmpty(oldValues)) {
            mode = ModeEnum.DELETE;
        }
        return mode;
    }

    private Map<String, Map<String, Object>> oldValuesByDb(Configuration configuration, BoundSql boundSql, OptMapperTable mapperTable, TableInfo tableInfo, String foreignIdName) {
        int index;
        Object paramObj = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String originalSql = boundSql.getSql().replaceAll("\\s+", " ");
        if (CollectionUtils.isNotEmpty((Collection)parameterMappings) && paramObj != null) {
            TypeHandlerRegistry registry = configuration.getTypeHandlerRegistry();
            if (registry.hasTypeHandler(paramObj.getClass())) {
                originalSql = originalSql.replaceFirst(PLACEHOLDER, this.sqlValue(paramObj));
            } else {
                MetaObject metaObject = configuration.newMetaObject(paramObj);
                for (ParameterMapping pm : parameterMappings) {
                    Object obj;
                    String proName = pm.getProperty();
                    if (metaObject.hasGetter(proName)) {
                        obj = metaObject.getValue(proName);
                        originalSql = originalSql.replaceFirst(PLACEHOLDER, this.sqlValue(obj));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(proName)) continue;
                    obj = boundSql.getAdditionalParameter(proName);
                    originalSql = originalSql.replaceFirst(PLACEHOLDER, this.sqlValue(obj));
                }
            }
        }
        if ((index = this.indexOfSqlStart(originalSql)) > 0) {
            originalSql = originalSql.substring(index);
        }
        log.info("\u6267\u884cSQL\uff1a{}", (Object)originalSql);
        String[] sqlArray = StringUtils.split((String)originalSql, (String)";");
        String currentNamespace = tableInfo.getCurrentNamespace();
        MybatisMapperProxy mybatisMapperProxy = MybatisUtils.getMybatisMapperProxy((Object)this);
        SqlSession sqlSession = mybatisMapperProxy.getSqlSession();
        String statementSql = currentNamespace + "." + SqlMethod.SELECT_LIST.getMethod();
        HashMap<String, Map<String, Object>> listMap = new HashMap<String, Map<String, Object>>(16);
        try {
            for (String sql : sqlArray) {
                Map<String, Map<String, Object>> oneMap = this.oneSql(sql, sqlSession, statementSql, boundSql, mapperTable, foreignIdName);
                if (oneMap == null) continue;
                listMap.putAll(oneMap);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6sql \u8bed\u53e5\u9519\u8bef\uff01", (Throwable)e);
        }
        if (MapUtils.isEmpty(listMap)) {
            return null;
        }
        return listMap;
    }

    private Map<String, Map<String, Object>> oneSql(String originalSql, SqlSession sqlSession, String statementSql, BoundSql boundSql, OptMapperTable mapperTable, String foreignIdName) {
        String sql = originalSql.replace("where", "WHERE");
        String selectSql = "AND " + sql.substring(sql.lastIndexOf("WHERE") + 5);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("ew", ((QueryWrapper)Wrappers.query().eq((Object)"1", (Object)1)).last(selectSql));
        List data = sqlSession.selectList(statementSql, map);
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            HashMap<String, Map<String, Object>> mapList = new HashMap<String, Map<String, Object>>(16);
            for (Object d : data) {
                Map<String, Object> vs = this.valueMap(d, mapperTable, boundSql.getParameterMappings(), foreignIdName);
                mapList.put(MapUtils.getString(vs, (Object)mapperTable.getIdPropertyName()), vs);
            }
            return mapList;
        }
        return null;
    }

    private String sqlValue(Object obj) {
        Object v = " ";
        if (obj instanceof String) {
            v = "'" + obj + "'";
        } else if (obj != null) {
            v = obj.toString();
        }
        return v;
    }

    private int indexOfSqlStart(String sql) {
        String upperCaseSql = sql.toUpperCase();
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(upperCaseSql.indexOf("SELECT "));
        set.add(upperCaseSql.indexOf("UPDATE "));
        set.add(upperCaseSql.indexOf("INSERT "));
        set.add(upperCaseSql.indexOf("DELETE "));
        set.remove(-1);
        if (CollectionUtils.isEmpty(set)) {
            return -1;
        }
        ArrayList list = new ArrayList(set);
        list.sort(Comparator.naturalOrder());
        return (Integer)list.get(0);
    }

    private boolean isIgnoreMethod(String methodId) throws Exception {
        int lastIndex = methodId.lastIndexOf(".");
        String mapperClassName = methodId.substring(0, lastIndex);
        String mapperMethodName = methodId.substring(lastIndex + 1);
        Class<?> mapperClass = Class.forName(mapperClassName);
        OptIgnore classIgnore = mapperClass.getAnnotation(OptIgnore.class);
        if (classIgnore != null) {
            return true;
        }
        return OptLogCache.ignoreMethod(mapperClass, mapperMethodName);
    }

    private Pair<TableInfo, OptMapperTable> entityTable(String sql) {
        TableNameParser parser = new TableNameParser(sql);
        Collection tables = parser.tables();
        if (CollectionUtils.isEmpty((Collection)tables)) {
            log.warn("\u6ca1\u6709\u83b7\u53d6\u5230\u8868\u540d\u79f0\uff01\uff01");
            return null;
        }
        String tableName = (String)tables.iterator().next();
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)tableName);
        if (tableInfo == null) {
            log.warn("\u5b9e\u4f53\u5bf9\u8c61\u8868\u4e3a\u7a7a\uff01");
            return null;
        }
        Class entityType = tableInfo.getEntityType();
        OptMapperTable mapperTable = OptLogCache.getCacheTableInfo(entityType, this.properties);
        if (!mapperTable.isRecord()) {
            if (!mapperTable.isLogTable()) {
                log.warn("\u6ca1\u6709\u9700\u8981\u8bb0\u5f55\u7684\u5b57\u6bb5\uff01");
            }
            return null;
        }
        return Pair.of((Object)tableInfo, (Object)mapperTable);
    }

    private Object sqlParams(BoundSql bound) {
        Object paramObject = bound.getParameterObject();
        Object params = null;
        if (paramObject instanceof Map) {
            Map map = (Map)PojoUtil.cast((Object)paramObject);
            params = new ArrayList(map.values()).get(0);
        } else if (paramObject instanceof BaseEntity) {
            params = PojoUtil.cast((Object)paramObject);
        }
        if (!(params instanceof List) && !(params instanceof BaseEntity)) {
            log.warn("\u975e\u5b9e\u4f53\u5bf9\u8c61\u7c7b\u578b\u53c2\u6570\u4e0d\u652f\u6301\uff01");
            return null;
        }
        return params;
    }

    private List<Map<String, Object>> newValueMap(Object object, OptMapperTable mapperTable, List<ParameterMapping> mappings) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (object instanceof List) {
            List data = (List)PojoUtil.cast((Object)object);
            data.forEach(d -> list.add(this.valueMap(d, mapperTable, mappings, null)));
        } else {
            list.add(this.valueMap(object, mapperTable, mappings, null));
        }
        return list;
    }

    private Map<String, Object> valueMap(Object bean, OptMapperTable mapperTable, List<ParameterMapping> mappings, String foreignIdName) {
        Map<String, OptMapperColumn> propertyMap = mapperTable.getPropertyMap();
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        try {
            String idName;
            for (ParameterMapping mapping : mappings) {
                String propertyName = mapping.getProperty();
                if (StringUtils.contains((CharSequence)propertyName, (CharSequence)".")) {
                    propertyName = StringUtils.substringAfter((String)propertyName, (String)".");
                }
                if (!propertyMap.containsKey(propertyName)) continue;
                valueMap.put(propertyName, this.getProperty(bean, propertyName));
            }
            if (StringUtils.isNotBlank((CharSequence)foreignIdName) && !valueMap.containsKey(foreignIdName)) {
                valueMap.put(foreignIdName, this.getProperty(bean, foreignIdName));
            }
            if (StringUtils.isNotBlank((CharSequence)(idName = mapperTable.getIdPropertyName())) && !valueMap.containsKey(idName)) {
                valueMap.put(idName, this.getProperty(bean, idName));
            }
        }
        catch (Exception e) {
            log.error("\u53cd\u5c04\u83b7\u53d6\u503c\u9519\u8bef\uff01", (Throwable)e);
        }
        return valueMap;
    }

    private Object getProperty(Object bean, String propertyName) throws IllegalAccessException {
        Field field = PojoUtil.fieldByName(bean.getClass(), (String)propertyName);
        field.setAccessible(true);
        return field.get(bean);
    }

    private <T> T getTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return this.getTarget(metaObject.getValue("h.target"));
        }
        return (T)PojoUtil.cast((Object)target);
    }
}

