/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.opt.util;

import cn.sinozg.applet.common.annotation.OptTie;
import cn.sinozg.applet.common.core.base.BaseEntity;
import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.WebUtil;
import cn.sinozg.applet.opt.cache.OptLogCache;
import cn.sinozg.applet.opt.enums.ModeEnum;
import cn.sinozg.applet.opt.module.AnalysisMiddleware;
import cn.sinozg.applet.opt.module.OptLogDiff;
import cn.sinozg.applet.opt.module.OptLogDiffPair;
import cn.sinozg.applet.opt.module.OptLogDiffTable;
import cn.sinozg.applet.opt.module.OptLogDiffTableChange;
import cn.sinozg.applet.opt.module.OptLogTableDetail;
import cn.sinozg.applet.opt.module.OptLogTableInfo;
import cn.sinozg.applet.opt.module.OptMapperColumn;
import cn.sinozg.applet.opt.module.OptTieCache;
import cn.sinozg.applet.opt.module.OptTieRecord;
import cn.sinozg.applet.opt.module.OptTieRelation;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.HandlerMapping;

public class OptUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OptUtil.class);
    private static final int MAX_LENGTH = 2000;

    public static Class<?> firstMethodParams(Method method, String requestMethod) {
        Type[] types;
        Class clazz;
        if (HttpMethod.POST.name().equals(requestMethod) && (clazz = PojoUtil.getGenericType((Type)(types = method.getGenericParameterTypes())[0])) != null && clazz != List.class && clazz != Map.class && clazz != Arrays.class && clazz != String.class && !clazz.isPrimitive()) {
            return clazz;
        }
        return null;
    }

    public static String requestParamsToJson(String requestMethod, JoinPoint joinPoint) {
        Object params;
        HttpServletRequest request = WebUtil.request();
        if (StringUtils.equalsAny((CharSequence)requestMethod, (CharSequence[])new CharSequence[]{HttpMethod.PUT.name(), HttpMethod.POST.name()})) {
            StringBuilder args = new StringBuilder();
            Object[] paramsArray = joinPoint.getArgs();
            if (paramsArray != null) {
                for (Object o : paramsArray) {
                    if (OptUtil.isFilterObject(o)) continue;
                    String jsonObj = JsonUtil.toJson((Object)o);
                    args.append(jsonObj).append(" ");
                }
            }
            params = args.toString();
        } else {
            params = HttpMethod.GET.name().equals(requestMethod) ? request.getParameterMap() : request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        }
        return OptUtil.substring(params);
    }

    public static boolean exclude(String info, List<String> include, List<String> exclude) {
        if (CollectionUtils.isNotEmpty(exclude) && exclude.contains(info)) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(include)) {
            return !include.contains(info);
        }
        return false;
    }

    public static String substring(Object params) {
        if (params == null) {
            return null;
        }
        String json = params instanceof String ? (String)params : JsonUtil.toJson((Object)params);
        if (json != null && json.length() > 2000) {
            json = json.substring(0, 2000);
        }
        return json;
    }

    public static <T> OptTieRelation<T> optTie(Class<T> clazz) {
        HashMap keyMap = new HashMap(16);
        keyMap.putIfAbsent(clazz, new OptTieRecord("id", null));
        List<OptTieCache<?>> list = OptUtil.optTieList(clazz, keyMap);
        OptTieCache.OptTieBuild<T> build = OptTieCache.build(clazz).array(false).subs(list);
        OptTieRelation<T> relation = new OptTieRelation<T>();
        relation.setTie(build.build());
        relation.setKeyMap(keyMap);
        return relation;
    }

    public static String allDiffJson(AnalysisMiddleware mom) {
        ArrayList<OptLogDiffTable> list = new ArrayList<OptLogDiffTable>();
        Map<Class<?>, List<OptLogTableInfo>> map = mom.getMap();
        for (Map.Entry<Class<?>, List<OptLogTableInfo>> e : map.entrySet()) {
            OptLogDiffTable table = OptUtil.getOneTableDiff(e.getValue(), mom);
            list.add(table);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            list.sort(Comparator.comparing(OptLogDiffTable::getDesc));
            return JsonUtil.toJson(list);
        }
        return null;
    }

    public static void diffWithDependency(AnalysisMiddleware mom, Class<?> tie) {
        if (mom.getMap().size() == 1) {
            List<OptLogTableInfo> tables = mom.getMap().values().iterator().next();
            OptLogDiffTable table = OptUtil.getOneTableDiff(tables, mom);
            mom.setDiff(table);
        } else {
            OptTieRelation<?> optTie = OptLogCache.optTie(tie);
            OptUtil.firstEntityClass(mom, optTie);
            OptUtil.itemTale(optTie.getTie(), mom, null, null);
        }
    }

    public static List<OptLogTableInfo> compare(List<Map<String, Object>> newValues, Map<String, Map<String, Object>> oldValues, Map<String, OptMapperColumn> propMap, OptLogTableDetail tableDetail, ModeEnum modeEnum) {
        ArrayList<OptLogTableInfo> list = new ArrayList<OptLogTableInfo>();
        if (ModeEnum.UPDATE == modeEnum) {
            boolean batch = newValues.size() > 1;
            for (Map.Entry<String, Map<String, Object>> e : oldValues.entrySet()) {
                OptLogTableInfo tableInfo;
                Map<String, Object> nm = newValues.get(0);
                if (batch) {
                    String idName = tableDetail.getIdName();
                    for (Map<String, Object> nv : newValues) {
                        String id = MapUtils.getString(nv, (Object)idName);
                        if (!e.getKey().equals(id)) continue;
                        nm = nv;
                        break;
                    }
                }
                if ((tableInfo = OptUtil.compareTable(nm, e.getValue(), propMap, tableDetail, modeEnum)) == null) continue;
                list.add(tableInfo);
            }
        } else if (ModeEnum.DELETE == modeEnum) {
            for (Map.Entry<String, Map<String, Object>> e : oldValues.entrySet()) {
                OptLogTableInfo tableInfo = OptUtil.compareTable(null, e.getValue(), propMap, tableDetail, modeEnum);
                if (tableInfo == null) continue;
                list.add(tableInfo);
            }
        } else {
            for (Map<String, Object> nv : newValues) {
                OptLogTableInfo tableInfo = OptUtil.compareTable(nv, null, propMap, tableDetail, modeEnum);
                if (tableInfo == null) continue;
                list.add(tableInfo);
            }
        }
        return list;
    }

    private static OptLogTableInfo compareTable(Map<String, Object> newValues, Map<String, Object> oldValues, Map<String, OptMapperColumn> propMap, OptLogTableDetail tableDetail, ModeEnum modeEnum) {
        String id;
        String idName = tableDetail.getIdName();
        String foreignIdName = tableDetail.getForeignIdName();
        String foreignId = null;
        if (oldValues != null) {
            if (StringUtils.isNotBlank((CharSequence)foreignIdName)) {
                foreignId = MapUtils.getString(oldValues, (Object)foreignIdName);
            }
            id = MapUtils.getString(oldValues, (Object)idName);
        } else {
            if (StringUtils.isNotBlank((CharSequence)foreignIdName)) {
                foreignId = MapUtils.getString(newValues, (Object)foreignIdName);
            }
            id = MapUtils.getString(newValues, (Object)idName);
        }
        ArrayList<OptLogDiff> fieldDiff = new ArrayList<OptLogDiff>();
        for (Map.Entry<String, OptMapperColumn> e : propMap.entrySet()) {
            String key = e.getKey();
            if (newValues != null && !newValues.containsKey(key)) continue;
            Object nv = MapUtils.getObject(newValues, (Object)key);
            Object ov = MapUtils.getObject(oldValues, (Object)key);
            Pair<String, String> pair = OptUtil.valueIsEquals(ov, nv);
            if (pair == null) continue;
            OptMapperColumn c = e.getValue();
            OptLogDiff diff = new OptLogDiff();
            diff.setDesc(c.getColumnDesc());
            diff.setNm(c.getPropertyName());
            diff.setNv((String)pair.getValue());
            diff.setOv((String)pair.getKey());
            fieldDiff.add(diff);
        }
        if (CollectionUtils.isEmpty(fieldDiff)) {
            return null;
        }
        OptLogTableInfo tableInfo = new OptLogTableInfo();
        tableInfo.setIdValue(id);
        tableInfo.setForeignId(foreignId);
        tableInfo.setDiff(fieldDiff);
        tableInfo.setMode(modeEnum);
        tableInfo.setTableDetail(tableDetail);
        return tableInfo;
    }

    private static Pair<String, String> valueIsEquals(Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null) {
            return null;
        }
        String ov = OptUtil.formatColumnValue(oldValue);
        String nv = OptUtil.formatColumnValue(newValue);
        if (oldValue == null || newValue == null) {
            return Pair.of((Object)ov, (Object)nv);
        }
        if (oldValue instanceof Long || oldValue instanceof Integer || oldValue instanceof Double || oldValue instanceof Float || oldValue instanceof BigDecimal || oldValue instanceof Short || oldValue instanceof Byte) {
            BigDecimal n;
            BigDecimal o = new BigDecimal(oldValue.toString());
            return o.compareTo(n = new BigDecimal(newValue.toString())) == 0 ? null : Pair.of((Object)ov, (Object)nv);
        }
        return StringUtils.equals((CharSequence)ov, (CharSequence)nv) ? null : Pair.of((Object)ov, (Object)nv);
    }

    public static String formatColumnValue(Object value) {
        if (value == null) {
            return null;
        }
        try {
            if (value instanceof Date) {
                LocalDateTime ldt = DateUtil.ldt((long)((Date)value).getTime());
                if (ldt.getHour() == 0 && ldt.getMinute() == 0 && ldt.getSecond() == 0) {
                    return DateUtil.formatDate((LocalDate)ldt.toLocalDate(), null);
                }
                return DateUtil.formatDateTime((LocalDateTime)ldt, null);
            }
            if (value instanceof LocalDate) {
                LocalDate localDate = (LocalDate)value;
                return DateUtil.formatDate((LocalDate)localDate, null);
            }
            if (value instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)value;
                return DateUtil.formatDateTime((LocalDateTime)localDateTime, null);
            }
        }
        catch (Exception e) {
            log.error("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u5f02\u5e38\uff0c\u8df3\u8fc7", (Throwable)e);
        }
        return value.toString();
    }

    private static List<OptTieCache<?>> optTieList(Class<?> clazz, Map<Class<?>, OptTieRecord> keyMap) {
        if (clazz == null) {
            return null;
        }
        List fields = PojoUtil.allField(clazz);
        ArrayList list = new ArrayList();
        for (Field field : fields) {
            OptTie optTie = field.getAnnotation(OptTie.class);
            if (optTie == null) continue;
            boolean array = field.getType() == List.class;
            Class<? extends BaseEntity> c = optTie.clazz();
            keyMap.putIfAbsent(c, new OptTieRecord(optTie.idName(), optTie.foreignName()));
            OptTieCache.OptTieBuild<? extends BaseEntity> sub = OptTieCache.build(c).array(array).key(optTie.foreignName()).desc(optTie.desc()).subs(OptUtil.optTieList(c, keyMap));
            list.add(sub.build());
        }
        return list;
    }

    private static void itemTale(OptTieCache<?> tie, AnalysisMiddleware mom, OptLogDiffTable diffTable, String pId) {
        if (StringUtils.isBlank((CharSequence)pId) && tie == null) {
            return;
        }
        boolean isFirst = diffTable == null && StringUtils.isBlank((CharSequence)pId);
        Class<?> currClazz = tie.getClazz();
        if (isFirst) {
            currClazz = mom.getMainClazz();
        }
        List list = null;
        if (currClazz == null) {
            log.error("\u672a\u627e\u5230\u4e3b\u8868\u7c7b\u578b\uff01\uff01\uff01");
        } else {
            list = (List)MapUtils.getObject(mom.getMap(), currClazz);
        }
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        OptLogDiffTable currTable = OptUtil.initDiffTable(list);
        HashMap<ModeEnum, OptLogDiffTableChange> subChange = new HashMap<ModeEnum, OptLogDiffTableChange>(16);
        for (OptLogTableInfo t : list) {
            if (!isFirst && !pId.equals(t.getForeignId())) continue;
            OptUtil.setTableDiffByMode(subChange, t, mom);
            List<OptTieCache<?>> subClazz = tie.getSubs();
            if (!CollectionUtils.isNotEmpty(subClazz)) continue;
            for (OptTieCache<?> ti : subClazz) {
                OptUtil.itemTale(ti, mom, currTable, t.getIdValue());
            }
        }
        OptUtil.setChangeList(subChange, currTable);
        if (diffTable != null) {
            PojoUtil.setBeanList((Object)diffTable, (Object)currTable, OptLogDiffTable::getTs, OptLogDiffTable::setTs);
        } else {
            mom.setDiff(currTable);
        }
    }

    private static void setTableDiffByMode(Map<ModeEnum, OptLogDiffTableChange> map, OptLogTableInfo t, AnalysisMiddleware mom) {
        ConcurrentSkipListMap<String, OptLogDiffPair> diff = new ConcurrentSkipListMap<String, OptLogDiffPair>();
        List<OptLogDiff> ds = t.getDiff();
        for (OptLogDiff d : ds) {
            diff.put(d.getNm(), new OptLogDiffPair(d.getOv(), d.getNv()));
        }
        OptLogDiffTableChange change = map.get((Object)t.getMode());
        if (change == null) {
            change = new OptLogDiffTableChange();
            change.setMode(t.getMode().getCode());
        }
        PojoUtil.setBeanList((Object)change, diff, OptLogDiffTableChange::getLs, OptLogDiffTableChange::setLs);
        map.put(t.getMode(), change);
        mom.addTable(t);
    }

    private static OptLogDiffTable getOneTableDiff(List<OptLogTableInfo> tables, AnalysisMiddleware mom) {
        OptLogDiffTable table = OptUtil.initDiffTable(tables);
        HashMap<ModeEnum, OptLogDiffTableChange> changeMap = new HashMap<ModeEnum, OptLogDiffTableChange>(16);
        for (OptLogTableInfo t : tables) {
            OptUtil.setTableDiffByMode(changeMap, t, mom);
        }
        OptUtil.setChangeList(changeMap, table);
        return table;
    }

    private static void setChangeList(Map<ModeEnum, OptLogDiffTableChange> changes, OptLogDiffTable table) {
        if (MapUtils.isNotEmpty(changes)) {
            ArrayList<OptLogDiffTableChange> temp = new ArrayList<OptLogDiffTableChange>(changes.values());
            table.setCs(temp);
        }
    }

    private static void firstEntityClass(AnalysisMiddleware mom, OptTieRelation<?> optTie) {
        OptTieCache<?> tie = optTie.getTie();
        Class clazz = tie.getClazz();
        Map<Class<?>, List<OptLogTableInfo>> entityMap = mom.getMap();
        Class mainClazz = null;
        if (entityMap.containsKey(clazz)) {
            mainClazz = clazz;
        } else {
            Map<Class<?>, OptTieRecord> keyMap = optTie.getKeyMap();
            ArrayList list = new ArrayList();
            for (Map.Entry<Class<?>, List<OptLogTableInfo>> e : entityMap.entrySet()) {
                if (keyMap.containsKey(e.getKey())) continue;
                list.add(e.getKey());
            }
            if (list.size() == 1) {
                mainClazz = (Class)list.get(0);
            }
        }
        mom.setMainClazz(mainClazz);
    }

    private static OptLogDiffTable initDiffTable(List<OptLogTableInfo> list) {
        OptLogTableInfo tableInfo = list.get(0);
        OptLogDiffTable table = new OptLogDiffTable();
        table.setDesc(tableInfo.getTableDetail().getTableDesc());
        List<OptLogDiff> ds = tableInfo.getDiff();
        ConcurrentSkipListMap<String, String> fs = new ConcurrentSkipListMap<String, String>();
        for (OptLogDiff d : ds) {
            fs.put(d.getNm(), d.getDesc());
        }
        table.setFs(fs);
        return table;
    }

    private static boolean isFilterObject(Object o) {
        return o instanceof MultipartFile || o instanceof HttpServletRequest || o instanceof HttpServletResponse;
    }
}

