package cn.sinozg.applet.common.annotation;

import cn.sinozg.applet.common.enums.BizType;
import cn.sinozg.applet.common.enums.OptType;
import org.apache.commons.lang3.StringUtils;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 自定义操作记录日志记录注解
 * @Description
 * @Copyright Copyright (c) 2024
 * @author xieyubin
 * @since 2024-02-27 17:43:53
 */
@Target({ElementType.PARAMETER, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface OptLog {
    /**  名称 默认取 @Operation.summary */
    String title() default StringUtils.EMPTY;
    /**  模块 @Tag.description */
    String module() default StringUtils.EMPTY;

    /** 功能 */
    BizType bizType() default BizType.OTHER;

    /** 操作人类别 */
    OptType optType() default OptType.MANAGE;

    /** 是否保存请求 和返回参数 */
    boolean saveParams() default true;

    /** 是否记录数据变动，默认记录 */
    boolean dataLog () default true;

    /** 关联关系 没有则从默认为第一个参数 */
    Class<?> tie() default Void.class;
}
