package cn.sinozg.applet.biz.opt.entity;

import cn.sinozg.applet.common.core.base.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
* 操作数据日志数据记录表
* @Description
* @Copyright Copyright (c) 2024
* @author xieyubin
* @since 2024-02-28 18:03:49
*/
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("sys_opt_log_text")
@Schema(name = "OptLogText", description = "操作数据日志数据记录")
public class OptLogText extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /** 主键id */
    @Schema(description = "主键id")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;


    /** 日志id */
    @Schema(description = "日志id")
    @TableField("log_id")
    private String logId;


    /** 请求参数 */
    @Schema(description = "请求参数")
    @TableField("json_param")
    private String jsonParam;


    /** 返回参数 */
    @Schema(description = "返回参数")
    @TableField("json_result")
    private String jsonResult;


    /** 错误消息 */
    @Schema(description = "错误消息")
    @TableField("error_msg")
    private String errorMsg;


    /** 所有的对比数据 */
    @Schema(description = "所有的对比数据")
    @TableField("json_all_diff")
    private String jsonAllDiff;

    /** 对比后的数据 */
    @Schema(description = "对比后的数据")
    @TableField("json_diff")
    private String jsonDiff;
}
