package cn.sinozg.applet.biz.opt.mapper;

import cn.sinozg.applet.biz.opt.entity.OptLogData;
import cn.sinozg.applet.biz.opt.vo.request.OptLogClearRequest;
import cn.sinozg.applet.biz.opt.vo.request.OptLogDataByBizIdPageRequest;
import cn.sinozg.applet.biz.opt.vo.request.OptLogDataPageRequest;
import cn.sinozg.applet.biz.opt.vo.response.OptLogDataByBizIdPageResponse;
import cn.sinozg.applet.biz.opt.vo.response.OptLogDataPageResponse;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* 操作、数据日志记录 Mapper 接口
* @Description
* @Copyright Copyright (c) 2024
* @author xieyubin
* @since 2024-02-28 18:03:49
*/
public interface OptLogDataMapper extends BaseMapper<OptLogData> {

    /**
    * 根据条件分页查询操作、数据日志记录列表
    *
    * @param page 分页信息
    * @param params 操作、数据日志记录信息
    * @return 操作、数据日志记录信息集合信息
    */
    IPage<OptLogDataPageResponse> pageInfo(Page<OptLogDataPageResponse> page, @Param("p") OptLogDataPageRequest params);

    /**
     * 根据业务id查询修改详情分页
     * @param page 分页
     * @param params 参数
     * @return 详情
     */
    IPage<OptLogDataByBizIdPageResponse> logDataDetailByBizId(Page<OptLogDataByBizIdPageResponse> page, @Param("p") OptLogDataByBizIdPageRequest params);

    /**
     * 根据id查询修改详情
     * @param params 参数
     * @return 详情
     */
    OptLogDataByBizIdPageResponse logDataDetailById(@Param("p") OptLogDataByBizIdPageRequest params);

    /**
     * 查询所有的id
     * @param params 参数
     * @return id 集合
     */
    List<String> idListInfo(@Param("p") OptLogClearRequest params);

    /**
     * 根据业务id 查询所有的id
     * @param params 参数
     * @return id 集合
     */
    List<String> idListInfoByBizId(@Param("p") OptLogClearRequest params);
}
