package cn.sinozg.applet.biz.opt.service;

import cn.sinozg.applet.biz.opt.entity.OptLogData;
import cn.sinozg.applet.biz.opt.vo.request.OptLogClearRequest;
import cn.sinozg.applet.biz.opt.vo.request.OptLogDataByBizIdPageRequest;
import cn.sinozg.applet.biz.opt.vo.request.OptLogDataPageRequest;
import cn.sinozg.applet.biz.opt.vo.response.OptLogDataByBizIdPageResponse;
import cn.sinozg.applet.biz.opt.vo.response.OptLogDataPageResponse;
import cn.sinozg.applet.common.core.base.BasePageResponse;
import cn.sinozg.applet.common.core.base.PagingRequest;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
* 操作、数据日志记录 服务类
* @Description
* @Copyright Copyright (c) 2024
* @author xieyubin
* @since 2024-02-28 18:03:49
*/
public interface OptLogDataService extends IService<OptLogData> {

    /**
    * 查询详情
    * @param id 主键
    * @return 对象
    */
    OptLogDataByBizIdPageResponse logDataDetailById(String id);

    /**
     * 根据业务ID 查询数据修改记录
     * @param page 分页
     * @param params 参数
     * @return 修改记录
     */
    BasePageResponse<List<OptLogDataByBizIdPageResponse>> logDataDetailByBizId(PagingRequest page, OptLogDataByBizIdPageRequest params);

    /**
     * 删除日志
     * @param params 参数
     */
    void clear(OptLogClearRequest params);
    /**
    * 分页查询
    * @param page 分页对象
    * @param params 参数
    * @return 分页集合
    */
    BasePageResponse<List<OptLogDataPageResponse>> pageInfo(PagingRequest page, OptLogDataPageRequest params);
}
