package cn.sinozg.applet.biz.opt.vo.response;

import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.opt.module.OptLogDiffTable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
* 操作、数据日志记录表 分页返回参数
* @Description
* @Copyright Copyright (c) 2024
* @author xieyubin
* @since 2024-02-28 18:03:49
*/
@Data
public class OptLogDataByBizIdPageResponse implements Serializable {

    private static final long serialVersionUID = 1L;
    /** 日志主键 */
    @Schema(description = "日志主键")
    private String logId;

    /** 差异Json信息 */
    @JsonIgnore
    private String jsonDiff;

    @Schema(description = "差异信息")
    private OptLogDiffTable diff;

    @Schema(description = "创建时间")
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS)
    private LocalDateTime createdTime;
}
