package cn.sinozg.applet.biz.opt.vo.response;

import cn.sinozg.applet.common.utils.DateUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
* 操作、数据日志记录表 分页返回参数
* @Description
* @Copyright Copyright (c) 2024
* @author xieyubin
* @since 2024-02-28 18:03:49
*/
@Data
@Schema(name = "OptLogDataPageResponse", description = "操作、数据日志记录 分页返回参数")
public class OptLogDataPageResponse implements Serializable {

    private static final long serialVersionUID = 1L;
    /** 日志主键 */
    @Schema(description = "日志主键")
    private String id;

    /** 模块标题 */
    @Schema(description = "模块标题")
    private String title;

    /** 模块 */
    @Schema(description = "模块")
    private String moduleName;

    /** 业务类型;00其它 01新增 02修改 03删除 */
    @Schema(description = "业务类型;00其它 01新增 02修改 03删除")
    private String businessType;

    /** 请求方式 */
    @Schema(description = "请求方式")
    private String requestMethod;

    /** 操作类别;00其它 01后台用户 02手机端用户 */
    @Schema(description = "操作类别;00其它 01后台用户 02手机端用户")
    private String optType;

    /** 操作人员 */
    @Schema(description = "操作人员")
    private String optName;

    /** 部门名称 */
    @Schema(description = "部门名称")
    private String deptName;

    /** 主机地址 */
    @Schema(description = "主机地址")
    private String optIp;

    /** 操作地点 */
    @Schema(description = "操作地点")
    private String optLocation;

    /** 操作状态;00正常 01异常 */
    @Schema(description = "操作状态;00正常 01异常")
    private String dataStatus;

    /** 创建时间 */
    @Schema(description = "创建时间")
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS)
    private LocalDateTime createdTime;
}
