package cn.sinozg.applet.common.annotation;

import org.apache.commons.lang3.StringUtils;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 操作日志字段注解 写在entity bean上的
 * 默认bean上的字段 去除了默认设置不记录的全部记录
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-02-27 20:46
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface OptLogField {
    /** 是否忽略 */
    boolean ignore() default false;
    /** 是否为id 默认id字段 id的 可以不管 */
    boolean id() default false;
    /** 注释，会先取 Schema description的值 */
    String desc() default StringUtils.EMPTY;
    /** 字段排序 默认 entity 的顺序 */
    int sort() default Integer.MAX_VALUE;
}
